/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.VariableInstanceDataEvent;
import org.kie.kogito.events.mongodb.codec.EventMongoDBCodecProvider;
import org.kie.kogito.mongodb.transaction.MongoDBTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDBEventPublisher
implements EventPublisher {
    private static final Logger logger = LoggerFactory.getLogger(MongoDBEventPublisher.class);
    static final String ID = "_id";
    private MongoCollection<ProcessInstanceDataEvent> processInstanceDataEventCollection;
    private MongoCollection<UserTaskInstanceDataEvent> userTaskInstanceDataEventCollection;
    private MongoCollection<VariableInstanceDataEvent> variableInstanceDataEventCollection;

    protected abstract MongoClient mongoClient();

    protected abstract MongoDBTransactionManager transactionManager();

    protected abstract boolean processInstancesEvents();

    protected abstract boolean userTasksEvents();

    protected abstract boolean variablesEvents();

    protected abstract String eventsDatabaseName();

    protected abstract String processInstancesEventsCollection();

    protected abstract String userTasksEventsCollection();

    protected abstract String variablesEventsCollection();

    protected void configure() {
        CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new EventMongoDBCodecProvider(), PojoCodecProvider.builder().automatic(true).build()})});
        MongoDatabase mongoDatabase = this.mongoClient().getDatabase(this.eventsDatabaseName()).withCodecRegistry(registry);
        this.processInstanceDataEventCollection = mongoDatabase.getCollection(this.processInstancesEventsCollection(), ProcessInstanceDataEvent.class).withCodecRegistry(registry);
        this.userTaskInstanceDataEventCollection = mongoDatabase.getCollection(this.userTasksEventsCollection(), UserTaskInstanceDataEvent.class).withCodecRegistry(registry);
        this.variableInstanceDataEventCollection = mongoDatabase.getCollection(this.variablesEventsCollection(), VariableInstanceDataEvent.class).withCodecRegistry(registry);
    }

    public void publish(DataEvent<?> event) {
        switch (event.getType()) {
            case "ProcessInstanceEvent": {
                this.publishEvent(this.processInstanceDataEventCollection, (ProcessInstanceDataEvent)event, this::processInstancesEvents);
                break;
            }
            case "UserTaskInstanceEvent": {
                this.publishEvent(this.userTaskInstanceDataEventCollection, (UserTaskInstanceDataEvent)event, this::userTasksEvents);
                break;
            }
            case "VariableInstanceEvent": {
                this.publishEvent(this.variableInstanceDataEventCollection, (VariableInstanceDataEvent)event, this::variablesEvents);
                break;
            }
            default: {
                logger.warn("Unknown type of event '{}', ignoring", (Object)event.getType());
            }
        }
    }

    private <T extends DataEvent<?>> void publishEvent(MongoCollection<T> collection, T event, BooleanSupplier enabled) {
        if (enabled.getAsBoolean()) {
            if (this.transactionManager().enabled()) {
                collection.insertOne(this.transactionManager().getClientSession(), event);
                collection.deleteOne(this.transactionManager().getClientSession(), Filters.eq((String)ID, (Object)event.getId()));
            } else {
                collection.insertOne(event);
                collection.deleteOne(Filters.eq((String)ID, (Object)event.getId()));
            }
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }
}

