/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb.codec;

import java.util.stream.Collectors;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceEventBody;
import org.kie.kogito.events.mongodb.codec.CodecUtils;

public class UserTaskInstanceDataEventCodec
implements CollectibleCodec<UserTaskInstanceDataEvent> {
    public UserTaskInstanceDataEvent generateIdIfAbsentFromDocument(UserTaskInstanceDataEvent userTaskInstanceDataEvent) {
        return userTaskInstanceDataEvent;
    }

    public boolean documentHasId(UserTaskInstanceDataEvent userTaskInstanceDataEvent) {
        return userTaskInstanceDataEvent.getId() != null;
    }

    public BsonValue getDocumentId(UserTaskInstanceDataEvent userTaskInstanceDataEvent) {
        return new BsonString(userTaskInstanceDataEvent.getId());
    }

    public UserTaskInstanceDataEvent decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return null;
    }

    public void encode(BsonWriter bsonWriter, UserTaskInstanceDataEvent userTaskInstanceDataEvent, EncoderContext encoderContext) {
        Document doc = new Document();
        CodecUtils.encodeDataEvent(doc, userTaskInstanceDataEvent);
        doc.put("kogitoUserTaskinstanceId", (Object)userTaskInstanceDataEvent.getKogitoUserTaskinstanceId());
        doc.put("kogitoUserTaskinstanceState", (Object)userTaskInstanceDataEvent.getKogitoUserTaskinstanceState());
        doc.put("data", (Object)this.encodeData((UserTaskInstanceEventBody)userTaskInstanceDataEvent.getData()));
        CodecUtils.codec().encode(bsonWriter, (Object)doc, encoderContext);
    }

    private Document encodeData(UserTaskInstanceEventBody data) {
        Document doc = new Document();
        doc.put("id", (Object)data.getId());
        doc.put("taskName", (Object)data.getTaskName());
        doc.put("taskDescription", (Object)data.getTaskDescription());
        doc.put("taskPriority", (Object)data.getTaskPriority());
        doc.put("referenceName", (Object)data.getReferenceName());
        doc.put("startDate", (Object)data.getStartDate());
        doc.put("completeDate", (Object)data.getCompleteDate());
        doc.put("state", (Object)data.getState());
        doc.put("actualOwner", (Object)data.getActualOwner());
        doc.put("potentialUsers", (Object)data.getPotentialUsers());
        doc.put("potentialGroups", (Object)data.getPotentialGroups());
        doc.put("excludedUsers", (Object)data.getExcludedUsers());
        doc.put("adminUsers", (Object)data.getAdminUsers());
        doc.put("adminGroups", (Object)data.getAdminGroups());
        doc.put("inputs", (Object)new Document(data.getInputs()));
        doc.put("outputs", (Object)new Document(data.getOutputs()));
        doc.put("processInstanceId", (Object)data.getProcessInstanceId());
        doc.put("rootProcessInstanceId", (Object)data.getRootProcessInstanceId());
        doc.put("processId", (Object)data.getProcessId());
        doc.put("rootProcessId", (Object)data.getRootProcessId());
        doc.put("identity", (Object)data.getIdentity());
        if (data.getComments() != null) {
            doc.put("comments", data.getComments().stream().map(c -> {
                Document cDoc = new Document();
                cDoc.put("id", (Object)c.getId());
                cDoc.put("content", (Object)c.getContent());
                cDoc.put("updatedAt", (Object)c.getUpdatedAt());
                cDoc.put("updatedBy", (Object)c.getUpdatedBy());
                return cDoc;
            }).collect(Collectors.toSet()));
        }
        if (data.getAttachments() != null) {
            doc.put("attachments", data.getAttachments().stream().map(a -> {
                Document aDoc = new Document();
                aDoc.put("id", (Object)a.getId());
                aDoc.put("content", (Object)a.getContent());
                aDoc.put("updatedAt", (Object)a.getUpdatedAt());
                aDoc.put("updatedBy", (Object)a.getUpdatedBy());
                aDoc.put("name", (Object)a.getName());
                return aDoc;
            }).collect(Collectors.toSet()));
        }
        return doc;
    }

    public Class<UserTaskInstanceDataEvent> getEncoderClass() {
        return UserTaskInstanceDataEvent.class;
    }
}

