/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Endpoint
implements Serializable {
    private String url;
    private String name;
    private Map<String, String> secondaryURLs = new HashMap<String, String>();
    private Map<String, String> labels = new HashMap<String, String>();

    public Endpoint() {
    }

    public Endpoint(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public Map<String, String> getSecondaryURLs() {
        return Collections.unmodifiableMap(this.secondaryURLs);
    }

    public void addSecondaryUrl(String name, String url) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Service port name can't be null or empty");
        }
        if (url == null || url.isEmpty()) {
            throw new NullPointerException("Endpoint URL can't be null or empty");
        }
        if (this.secondaryURLs == null) {
            this.secondaryURLs = new HashMap<String, String>();
        }
        this.secondaryURLs.put(name, url);
    }

    public String getSecondaryUrl(String name) {
        return this.secondaryURLs.get(name);
    }

    public void removeSecondaryUrl(String name) {
        this.secondaryURLs.remove(name);
    }

    public void setUrlIfEmpty(String name, String url) {
        if (url != null && !url.isEmpty() && this.urlIsEmpty()) {
            this.setUrl(url);
            this.setName(name);
        }
    }

    public boolean urlIsEmpty() {
        return this.getUrl() == null || this.getUrl().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.name, endpoint.name) && Objects.equals(this.url, endpoint.url) && Objects.equals(this.secondaryURLs, endpoint.secondaryURLs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.secondaryURLs);
    }
}

