/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointBuilder;
import org.kie.kogito.addons.k8s.EndpointDiscovery;

public class KubernetesServiceEndpointDiscovery
implements EndpointDiscovery {
    private final EndpointBuilder portBuilder = new EndpointBuilder();
    private KubernetesClient kubernetesClient;

    public KubernetesServiceEndpointDiscovery(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    @Override
    public Optional<Endpoint> findEndpoint(String namespace, String name) {
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(name)).get();
        if (service == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.portBuilder.buildFrom(service));
    }

    @Override
    public List<Endpoint> findEndpoint(String namespace, Map<String, String> labels) {
        List services = ((ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withLabels(labels)).list()).getItems();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        services.forEach(s -> {
            Endpoint endpoint = this.portBuilder.buildFrom((Service)s);
            if (endpoint != null) {
                endpoints.add(endpoint);
            }
        });
        return endpoints;
    }
}

