/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.processes;

import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.LocalUriId;
import org.kie.kogito.incubation.processes.AttachmentIds;
import org.kie.kogito.incubation.processes.CommentIds;
import org.kie.kogito.incubation.processes.TaskId;

public class TaskInstanceId
extends LocalUriId
implements LocalId {
    public static final String PREFIX = "instances";
    private final TaskId taskId;
    private final String taskInstanceId;

    public TaskInstanceId(TaskId taskId, String taskInstanceId) {
        super(taskId.asLocalUri().append(PREFIX).append(taskInstanceId));
        LocalId localDecisionId = taskId.toLocalId();
        if (!localDecisionId.asLocalUri().startsWith("processes")) {
            throw new IllegalArgumentException("Not a valid process path");
        }
        this.taskId = taskId;
        this.taskInstanceId = taskInstanceId;
    }

    public LocalId toLocalId() {
        return this;
    }

    public TaskId taskId() {
        return this.taskId;
    }

    public String taskInstanceId() {
        return this.taskInstanceId;
    }

    public AttachmentIds attachments() {
        return new AttachmentIds(this);
    }

    public CommentIds comments() {
        return new CommentIds(this);
    }
}

