/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.io.Resource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.kie.kogito.codegen.core.CustomDashboardGeneratedUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;

class CustomDashboardGeneratedUtilsTest {
    CustomDashboardGeneratedUtilsTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void loadCustomGrafanaDashboardsList(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAppPaths(AppPaths.fromTestDir((Path)new File(".").toPath())).build();
        Collection retrieved = CustomDashboardGeneratedUtils.loadCustomGrafanaDashboardsList((KogitoBuildContext)context);
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertEquals((int)2, (int)retrieved.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void addToGeneratedFiles(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAppPaths(AppPaths.fromTestDir((Path)new File(".").toPath())).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])context.getAppPaths().getPaths());
        Map dashboardJsonsMap = CustomDashboardGeneratedUtils.getMappedJsons((Collection)collectedResources);
        ArrayList toPopulate = new ArrayList();
        CustomDashboardGeneratedUtils.addToGeneratedFiles((List)((List)dashboardJsonsMap.get("operational-dashboard-")), toPopulate, (BiFunction)CustomDashboardGeneratedUtils.operationalFunction, (String)"operational-dashboard-");
        Assertions.assertEquals((int)((List)dashboardJsonsMap.get("operational-dashboard-")).size(), (int)toPopulate.size());
        String sourcePath = ((Resource)((List)dashboardJsonsMap.get("operational-dashboard-")).get(0)).getSourcePath();
        String originalFileName = sourcePath.substring(sourcePath.lastIndexOf(File.separator) + 1);
        this.validateGeneratedFile((GeneratedFile)toPopulate.iterator().next(), "operational-dashboard-", originalFileName);
        toPopulate = new ArrayList();
        CustomDashboardGeneratedUtils.addToGeneratedFiles((List)((List)dashboardJsonsMap.get("domain-dashboard-")), toPopulate, (BiFunction)CustomDashboardGeneratedUtils.domainFunction, (String)"domain-dashboard-");
        Assertions.assertEquals((int)((List)dashboardJsonsMap.get("domain-dashboard-")).size(), (int)toPopulate.size());
        sourcePath = ((Resource)((List)dashboardJsonsMap.get("domain-dashboard-")).get(0)).getSourcePath();
        originalFileName = sourcePath.substring(sourcePath.lastIndexOf(File.separator) + 1);
        this.validateGeneratedFile((GeneratedFile)toPopulate.iterator().next(), "domain-dashboard-", originalFileName);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void getMappedJsons(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAppPaths(AppPaths.fromTestDir((Path)new File(".").toPath())).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])context.getAppPaths().getPaths());
        Map retrieved = CustomDashboardGeneratedUtils.getMappedJsons((Collection)collectedResources);
        Assertions.assertEquals((int)2, (int)retrieved.size());
        Assertions.assertEquals((int)1, (int)((List)retrieved.get("operational-dashboard-")).size());
        Assertions.assertEquals((int)1, (int)((List)retrieved.get("domain-dashboard-")).size());
    }

    private void validateGeneratedFile(GeneratedFile toValidate, String dashboardType, String originalFileName) {
        Assertions.assertEquals((Object)"DASHBOARD", (Object)toValidate.type().name());
        Assertions.assertEquals((Object)"STATIC_HTTP_RESOURCE", (Object)toValidate.category().name());
        String fileName = toValidate.relativePath().substring(toValidate.relativePath().lastIndexOf(File.separator) + 1);
        Assertions.assertTrue((boolean)fileName.startsWith(dashboardType));
        Assertions.assertEquals((Object)originalFileName, (Object)fileName);
    }
}

