/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;

class GeneratedFileValidationTest {
    GeneratedFileValidationTest() {
    }

    @Test
    public void validateGeneratedFileTypes() {
        List<GeneratedFile> generatedFiles = Arrays.asList(new GeneratedFile(GeneratedFileType.SOURCE, "myPath1", ""), new GeneratedFile(GeneratedFileType.INTERNAL_RESOURCE, "myPath2", ""), new GeneratedFile(GeneratedFileType.COMPILED_CLASS, "myPath3", ""), new GeneratedFile(GeneratedFileType.STATIC_HTTP_RESOURCE, "myPath4", ""));
        GeneratedFileValidation.validateGeneratedFileTypes(generatedFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.INTERNAL_RESOURCE, GeneratedFileType.Category.STATIC_HTTP_RESOURCE, GeneratedFileType.Category.COMPILED_CLASS));
        Set<GeneratedFileType.Category> categories = Collections.singleton(GeneratedFileType.Category.SOURCE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneratedFileValidation.validateGeneratedFileTypes((Collection)generatedFiles, (Collection)categories)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("myPath2").hasMessageContaining("myPath3").hasMessageContaining("myPath4");
    }

    @Test
    public void validateGeneratedFileWithMetaInfResource() {
        List<GeneratedFile> generatedFiles = Arrays.asList(new GeneratedFile(GeneratedFileType.STATIC_HTTP_RESOURCE, "META-INF/resources/myPath1", ""));
        GeneratedFileValidation.validateGeneratedFileTypes(generatedFiles, Arrays.asList(GeneratedFileType.Category.STATIC_HTTP_RESOURCE));
    }
}

