/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.codegen.common.GeneratedFile;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.ConfigGenerator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.core.ApplicationConfigGenerator;
import org.mockito.Mockito;

public class ApplicationConfigGeneratorTest {
    private static final KogitoBuildContext context = JavaKogitoBuildContext.builder().withPackageName("org.kie.kogito.test").withAddonsConfig(AddonsConfig.DEFAULT).build();

    @Test
    public void withConfig() {
        ApplicationConfigGenerator generator = new ApplicationConfigGenerator(context);
        ConfigGenerator mockGenerator = (ConfigGenerator)Mockito.mock(ConfigGenerator.class);
        ApplicationConfigGenerator returnedConfigGenerator = generator.addConfigGenerator(mockGenerator);
        ((ObjectAssert)Assertions.assertThat((Object)returnedConfigGenerator).isNotNull()).isSameAs((Object)generator);
    }

    @Test
    public void withConfigNull() {
        ApplicationConfigGenerator generator = new ApplicationConfigGenerator(context);
        ApplicationConfigGenerator returnedConfigGenerator = generator.addConfigGenerator(null);
        ((ObjectAssert)Assertions.assertThat((Object)returnedConfigGenerator).isNotNull()).isSameAs((Object)generator);
    }

    @Test
    public void configBeanGenerationInJavaContextTest() {
        ApplicationConfigGenerator generator = new ApplicationConfigGenerator(context);
        Collection files = generator.generate();
        Assertions.assertThat((boolean)this.containsGeneratedFile("ConfigBean", files)).isTrue();
        Assertions.assertThat((boolean)this.containsGeneratedFile("ApplicationConfig", files)).isTrue();
    }

    @Test
    public void configBeanGenerationInSpringContextTest() {
        KogitoBuildContext context = SpringBootKogitoBuildContext.builder().withPackageName("org.kie.kogito.test").withAddonsConfig(AddonsConfig.DEFAULT).build();
        ApplicationConfigGenerator generator = new ApplicationConfigGenerator(context);
        Collection files = generator.generate();
        Assertions.assertThat((boolean)this.containsGeneratedFile("ConfigBean", files)).isTrue();
        Assertions.assertThat((boolean)this.containsGeneratedFile("ApplicationConfig", files)).isTrue();
    }

    @Test
    public void avoidConfigBeanGenerationInQuarkusContextTest() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withPackageName("org.kie.kogito.test").withAddonsConfig(AddonsConfig.DEFAULT).build();
        ApplicationConfigGenerator generator = new ApplicationConfigGenerator(context);
        Collection files = generator.generate();
        Assertions.assertThat((boolean)this.containsGeneratedFile("ConfigBean", files)).isFalse();
        Assertions.assertThat((boolean)this.containsGeneratedFile("ApplicationConfig", files)).isTrue();
    }

    private boolean containsGeneratedFile(String className, Collection<GeneratedFile> files) {
        return files.stream().anyMatch(generatedFile -> generatedFile.relativePath().endsWith(className + ".java"));
    }
}

