/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.ConfigBeanGenerator;

public class ConfigBeanGeneratorTest {
    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generate(KogitoBuildContext.Builder contextBuilder) {
        if (!"Quarkus".equals(contextBuilder.build().name())) {
            Assertions.assertThat((Optional)contextBuilder.build().getGAV()).isEmpty();
            Optional<MethodCallExpr> setGavNull = this.getGavMethodCallExpr(contextBuilder);
            setGavNull.ifPresent(methodCallExpr -> Assertions.assertThat((String)methodCallExpr.toString()).contains(new CharSequence[]{"null"}));
            KogitoGAV kogitoGAV = new KogitoGAV("groupId", "artifactId", "version");
            contextBuilder.withGAV(kogitoGAV);
            Optional<MethodCallExpr> setGav = this.getGavMethodCallExpr(contextBuilder);
            setGav.ifPresent(methodCallExpr -> ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)methodCallExpr.toString()).contains(new CharSequence[]{kogitoGAV.getGroupId()})).contains(new CharSequence[]{kogitoGAV.getArtifactId()})).contains(new CharSequence[]{kogitoGAV.getVersion()}));
        }
    }

    private Optional<MethodCallExpr> getGavMethodCallExpr(KogitoBuildContext.Builder contextBuilder) {
        ConfigBeanGenerator configBeanGenerator = new ConfigBeanGenerator(contextBuilder.build());
        CompilationUnit compilationUnit = configBeanGenerator.toCompilationUnit();
        Assertions.assertThat((String)compilationUnit.toString()).doesNotContain(new CharSequence[]{configBeanGenerator.GAV_TEMPLATE});
        Optional setGav = compilationUnit.findFirst(MethodCallExpr.class, mc -> "setGav".equals(mc.getNameAsString()));
        boolean shouldMethodPresent = contextBuilder.build().hasDI();
        Assertions.assertThat((boolean)setGav.isPresent()).isEqualTo(shouldMethodPresent);
        return setGav;
    }
}

