/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.GeneratedFile;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.io.Resource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.CustomDashboardGeneratedUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;

class CustomDashboardGeneratedUtilsTest {
    CustomDashboardGeneratedUtilsTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void loadCustomGrafanaDashboardsList(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAppPaths(AppPaths.fromTestDir((Path)new File(".").toPath())).build();
        Collection retrieved = CustomDashboardGeneratedUtils.loadCustomGrafanaDashboardsList((KogitoBuildContext)context);
        Assertions.assertThat((Collection)retrieved).hasSize(2);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void addToGeneratedFiles(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAppPaths(AppPaths.fromTestDir((Path)new File(".").toPath())).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])context.getAppPaths().getPaths());
        Map dashboardJsonsMap = CustomDashboardGeneratedUtils.getMappedJsons((Collection)collectedResources);
        ArrayList toPopulate = new ArrayList();
        CustomDashboardGeneratedUtils.addToGeneratedFiles((List)((List)dashboardJsonsMap.get("operational-dashboard-")), toPopulate, (BiFunction)CustomDashboardGeneratedUtils.operationalFunction, (String)"operational-dashboard-");
        Assertions.assertThat(toPopulate).hasSameSizeAs((Iterable)dashboardJsonsMap.get("operational-dashboard-"));
        String sourcePath = ((Resource)((List)dashboardJsonsMap.get("operational-dashboard-")).get(0)).getSourcePath();
        String originalFileName = sourcePath.substring(sourcePath.lastIndexOf(File.separator) + 1);
        this.validateGeneratedFile((GeneratedFile)toPopulate.iterator().next(), "operational-dashboard-", originalFileName);
        toPopulate = new ArrayList();
        CustomDashboardGeneratedUtils.addToGeneratedFiles((List)((List)dashboardJsonsMap.get("domain-dashboard-")), toPopulate, (BiFunction)CustomDashboardGeneratedUtils.domainFunction, (String)"domain-dashboard-");
        Assertions.assertThat(toPopulate).hasSameSizeAs((Iterable)dashboardJsonsMap.get("domain-dashboard-"));
        sourcePath = ((Resource)((List)dashboardJsonsMap.get("domain-dashboard-")).get(0)).getSourcePath();
        originalFileName = sourcePath.substring(sourcePath.lastIndexOf(File.separator) + 1);
        this.validateGeneratedFile((GeneratedFile)toPopulate.iterator().next(), "domain-dashboard-", originalFileName);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void getMappedJsons(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAppPaths(AppPaths.fromTestDir((Path)new File(".").toPath())).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])context.getAppPaths().getPaths());
        Map retrieved = CustomDashboardGeneratedUtils.getMappedJsons((Collection)collectedResources);
        Assertions.assertThat((Map)retrieved).hasSize(2);
        Assertions.assertThat((List)((List)retrieved.get("operational-dashboard-"))).hasSize(1);
        Assertions.assertThat((List)((List)retrieved.get("domain-dashboard-"))).hasSize(1);
    }

    private void validateGeneratedFile(GeneratedFile toValidate, String dashboardType, String originalFileName) {
        Assertions.assertThat((String)toValidate.type().name()).isEqualTo("DASHBOARD");
        Assertions.assertThat((String)toValidate.category().name()).isEqualTo("STATIC_HTTP_RESOURCE");
        String fileName = toValidate.relativePath().substring(toValidate.relativePath().lastIndexOf(File.separator) + 1);
        ((AbstractStringAssert)Assertions.assertThat((String)fileName).startsWith((CharSequence)dashboardType)).isEqualTo(originalFileName);
    }
}

