/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.kie.api.io.Resource;
import org.kie.kogito.codegen.api.io.CollectedResource;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;

class CollectedResourceProducerTest {
    CollectedResourceProducerTest() {
    }

    @Test
    void shouldNotContainDirectories() {
        Assertions.assertThat((long)CollectedResourceProducer.fromDirectory((Path)Paths.get("src/main/resources", new String[0])).stream().map(CollectedResource::resource).map(Resource::getSourcePath).map(File::new).filter(File::isDirectory).count()).isZero();
    }

    @Test
    @EnabledOnOs(value={OS.LINUX, OS.MAC})
    void fromDirectoryShouldNotContainHiddenFiles() {
        Assertions.assertThat((long)CollectedResourceProducer.fromDirectory((Path)Paths.get("src/test/resources", new String[0])).stream().map(CollectedResource::resource).map(Resource::getSourcePath).map(File::new).filter(f -> f.getName().contains(".gitkeep") || f.getName().contains("a-file-within-a-hidden-dir.txt") || f.getName().contains(".a-hidden-file.txt")).count()).isZero();
    }

    @Test
    @EnabledOnOs(value={OS.LINUX, OS.MAC})
    void fromDirectoryInitialHiddenDirShouldNotContainFiles() {
        Assertions.assertThat((int)CollectedResourceProducer.fromDirectory((Path)Paths.get("src/test/resources/.hidden-dir", new String[0])).size()).isZero();
    }

    @Test
    @EnabledOnOs(value={OS.LINUX, OS.MAC})
    void fromFilesHiddenDirShouldNotContainFiles() {
        Path basePath = Paths.get("src/test/resources/.hidden-dir", new String[0]).toAbsolutePath();
        File hiddenFile = basePath.resolve("a-file-within-a-hidden-dir.txt").toFile();
        Assertions.assertThat((int)CollectedResourceProducer.fromFiles((Path)basePath, (File[])new File[]{hiddenFile}).size()).isZero();
    }
}

