/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.core.AbstractGenerator;
import org.kie.kogito.codegen.core.ApplicationContainerGenerator;
import org.kie.kogito.codegen.core.ApplicationGenerator;

public class ApplicationGeneratorTest {
    private static final String PACKAGE_NAME = "org.drools.test";
    private static final String EXPECTED_APPLICATION_NAME = "org.drools.test.Application";
    private static final KogitoBuildContext context = JavaKogitoBuildContext.builder().withPackageName("org.drools.test").withAddonsConfig(AddonsConfig.DEFAULT).build();

    @Test
    public void targetCanonicalName() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(context);
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isNotNull();
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isEqualTo(EXPECTED_APPLICATION_NAME);
    }

    @Test
    public void generatedFilePath() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(context);
        String path = appGenerator.generateApplicationDescriptor().relativePath();
        ((AbstractStringAssert)Assertions.assertThat((String)path).isNotNull()).isEqualTo(EXPECTED_APPLICATION_NAME.replace(".", "/") + ".java");
    }

    @Test
    public void compilationUnit() {
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(context);
        this.assertCompilationUnit(appGenerator.getCompilationUnitOrThrow(), false);
    }

    @Test
    public void compilationUnitWithCDI() {
        KogitoBuildContext quarkusContext = QuarkusKogitoBuildContext.builder().withPackageName(PACKAGE_NAME).withAddonsConfig(AddonsConfig.DEFAULT).build();
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(quarkusContext);
        this.assertCompilationUnit(appGenerator.getCompilationUnitOrThrow(), true);
    }

    @Test
    public void applicationSectionReplace() {
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(context);
        this.assertApplicationPlaceholderReplace(appGenerator, 0L);
        appGenerator.withSections(Arrays.asList("Processes", "DecisionModels"));
        this.assertApplicationPlaceholderReplace(appGenerator, 2L);
    }

    @Test
    public void registerGeneratorIfEnabled() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(context);
        MockGenerator disabledGenerator = new MockGenerator(context, false);
        MockGenerator enabledGenerator = new MockGenerator(context, true);
        Assertions.assertThat((Optional)appGenerator.registerGeneratorIfEnabled((Generator)disabledGenerator)).isEmpty();
        Assertions.assertThat((Iterable)appGenerator.getGenerators()).isEmpty();
        Assertions.assertThat((Optional)appGenerator.registerGeneratorIfEnabled((Generator)enabledGenerator)).isNotEmpty();
        Assertions.assertThat((Iterable)appGenerator.getGenerators()).hasSize(1);
    }

    private void assertCompilationUnit(CompilationUnit compilationUnit, boolean checkCDI) {
        Assertions.assertThat((Object)compilationUnit).isNotNull();
        Assertions.assertThat((Optional)compilationUnit.getPackageDeclaration()).isPresent();
        Assertions.assertThat((Object)((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getName()).hasToString(PACKAGE_NAME);
        Assertions.assertThat((List)compilationUnit.getTypes()).isNotNull();
        Assertions.assertThat((List)compilationUnit.getTypes()).hasSize(1);
        TypeDeclaration mainAppClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        Assertions.assertThat((Object)mainAppClass).isNotNull();
        Assertions.assertThat((Object)mainAppClass.getName()).hasToString("Application");
        if (checkCDI) {
            Assertions.assertThat((List)mainAppClass.getAnnotations()).isNotEmpty();
            Assertions.assertThat((Optional)mainAppClass.getAnnotationByName("Singleton")).isPresent();
        } else {
            Assertions.assertThat((Optional)mainAppClass.getAnnotationByName("Singleton")).isNotPresent();
        }
        Assertions.assertThat((List)mainAppClass.getMembers()).isNotNull();
    }

    private void assertApplicationPlaceholderReplace(ApplicationContainerGenerator appGenerator, long expectedParams) {
        CompilationUnit compilationUnit = appGenerator.getCompilationUnitOrThrow();
        Optional<NodeList> expressions = compilationUnit.findFirst(MethodCallExpr.class, mtd -> "loadEngines".equals(mtd.getNameAsString())).map(MethodCallExpr::getArguments);
        Assertions.assertThat(expressions).isPresent();
        expressions.get().forEach(expression -> Assertions.assertThat((String)expression.toString()).doesNotContain(new CharSequence[]{"$"}));
        long numberOfNull = expressions.get().stream().filter(Expression::isNullLiteralExpr).count();
        Assertions.assertThat((long)numberOfNull).isZero();
        Assertions.assertThat((int)expressions.get().size()).isEqualTo(expectedParams);
    }

    static class MockGenerator
    extends AbstractGenerator {
        private final boolean enabled;

        protected MockGenerator(KogitoBuildContext context, boolean enabled) {
            super(context, "mockGenerator");
            this.enabled = enabled;
        }

        public Optional<ApplicationSection> section() {
            return Optional.empty();
        }

        public Collection<GeneratedFile> generate() {
            return Collections.emptyList();
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

