/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.core;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.AbstractGenerator;
import org.kie.kogito.codegen.core.ApplicationContainerGenerator;
import org.kie.kogito.codegen.core.ApplicationGenerator;

public class ApplicationGeneratorTest {
    private static final String EXPECTED_APPLICATION_NAME = "org.kie.kogito.app.Application";

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void targetCanonicalName(KogitoBuildContext.Builder contextBuilder) {
        ApplicationGenerator appGenerator = new ApplicationGenerator(contextBuilder.build());
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isNotNull();
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isEqualTo(EXPECTED_APPLICATION_NAME);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void targetCanonicalNameDifferentPackage(KogitoBuildContext.Builder contextBuilder) {
        String differentPackageName = "org.drools.test";
        String differentPackageExpectedApplicationName = "org.drools.test.Application";
        contextBuilder.withPackageName("org.drools.test");
        ApplicationGenerator appGenerator = new ApplicationGenerator(contextBuilder.build());
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isNotNull();
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isEqualTo("org.drools.test.Application");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generatedFilePath(KogitoBuildContext.Builder contextBuilder) {
        ApplicationGenerator appGenerator = new ApplicationGenerator(contextBuilder.build());
        String path = appGenerator.generateApplicationDescriptor().relativePath();
        ((AbstractStringAssert)Assertions.assertThat((String)path).isNotNull()).isEqualTo(EXPECTED_APPLICATION_NAME.replace(".", "/") + ".java");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void compilationUnit(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(context);
        this.assertCompilationUnit(appGenerator.getCompilationUnitOrThrow(), context.hasDI());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void compilationUnitWithCDI(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(context);
        this.assertCompilationUnit(appGenerator.getCompilationUnitOrThrow(), context.hasDI());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void applicationSectionReplace(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(context);
        this.assertApplicationPlaceholderReplace(appGenerator, context.hasDI(), 0L);
        appGenerator.withSections(Arrays.asList("Processes", "DecisionModels"));
        this.assertApplicationPlaceholderReplace(appGenerator, context.hasDI(), 2L);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void registerGeneratorIfEnabled(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ApplicationGenerator appGenerator = new ApplicationGenerator(context);
        MockGenerator disabledGenerator = new MockGenerator(context, false);
        MockGenerator enabledGenerator = new MockGenerator(context, true);
        Assertions.assertThat((Optional)appGenerator.registerGeneratorIfEnabled((Generator)disabledGenerator)).isEmpty();
        Assertions.assertThat((Iterable)appGenerator.getGenerators()).isEmpty();
        Assertions.assertThat((Optional)appGenerator.registerGeneratorIfEnabled((Generator)enabledGenerator)).isNotEmpty();
        Assertions.assertThat((Iterable)appGenerator.getGenerators()).hasSize(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void filterRestIfDisabled(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ApplicationGenerator appGenerator = new ApplicationGenerator(context);
        MockGenerator restGenerator = new MockGenerator(context, true, true);
        Assertions.assertThat((Optional)appGenerator.registerGeneratorIfEnabled((Generator)restGenerator)).isNotEmpty();
        Assertions.assertThat((Iterable)appGenerator.getGenerators()).hasSize(1);
        if (context.hasREST()) {
            context.setApplicationProperty("kogito.generate.rest", (Object)"false");
            Assertions.assertThat((List)appGenerator.generateComponents()).isEmpty();
            context.setApplicationProperty("kogito.generate.rest", (Object)"true");
            ((ListAssert)((ListAssert)Assertions.assertThat((List)appGenerator.generateComponents()).isNotEmpty()).hasSize(1)).matches(files -> files.stream().anyMatch(gf -> Generator.REST_TYPE.equals(gf.type())));
        } else {
            Assertions.assertThat((List)appGenerator.generateComponents()).isEmpty();
        }
    }

    private void assertCompilationUnit(CompilationUnit compilationUnit, boolean checkCDI) {
        Assertions.assertThat((Object)compilationUnit).isNotNull();
        Assertions.assertThat((Optional)compilationUnit.getPackageDeclaration()).isPresent();
        Assertions.assertThat((Object)((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getName()).hasToString("org.kie.kogito.app");
        Assertions.assertThat((List)compilationUnit.getTypes()).isNotNull();
        Assertions.assertThat((List)compilationUnit.getTypes()).hasSize(1);
        TypeDeclaration mainAppClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        Assertions.assertThat((Object)mainAppClass).isNotNull();
        Assertions.assertThat((Object)mainAppClass.getName()).hasToString("Application");
        if (checkCDI) {
            Assertions.assertThat((List)mainAppClass.getAnnotations()).isNotEmpty();
        } else {
            Assertions.assertThat((List)mainAppClass.getAnnotations()).isEmpty();
        }
        Assertions.assertThat((List)mainAppClass.getMembers()).isNotNull();
    }

    private void assertApplicationPlaceholderReplace(ApplicationContainerGenerator appGenerator, boolean hasDI, long expectedParams) {
        CompilationUnit compilationUnit = appGenerator.getCompilationUnitOrThrow();
        Optional<NodeList> expressions = compilationUnit.findFirst(MethodCallExpr.class, mtd -> "loadEngines".equals(mtd.getNameAsString())).map(MethodCallExpr::getArguments);
        if (hasDI) {
            Assertions.assertThat(expressions).isEmpty();
        } else {
            Assertions.assertThat(expressions).isPresent();
            expressions.get().forEach(expression -> Assertions.assertThat((String)expression.toString()).doesNotContain(new CharSequence[]{"$"}));
            long numberOfNull = expressions.get().stream().filter(Expression::isNullLiteralExpr).count();
            Assertions.assertThat((long)numberOfNull).isZero();
            Assertions.assertThat((int)expressions.get().size()).isEqualTo(expectedParams);
        }
    }

    static class MockGenerator
    extends AbstractGenerator {
        private final boolean enabled;
        private final boolean produceREST;

        protected MockGenerator(KogitoBuildContext context, boolean enabled) {
            this(context, enabled, false);
        }

        protected MockGenerator(KogitoBuildContext context, boolean enabled, boolean produceREST) {
            super(context, "mockGenerator");
            this.enabled = enabled;
            this.produceREST = produceREST;
        }

        public Optional<ApplicationSection> section() {
            return Optional.empty();
        }

        public Collection<GeneratedFile> generate() {
            if (this.produceREST) {
                return Collections.singleton(new GeneratedFile(REST_TYPE, "my/path", ""));
            }
            return Collections.emptyList();
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

