/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.generator;

import java.io.File;
import java.util.List;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.generator.KogitoJavaClientCodegen;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.CodegenConfigurator;
import org.openapitools.codegen.config.GlobalSettings;

public class OpenApiClientGeneratorWrapper {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String MODEL_PACKAGE = "model";
    private static final String GENERATOR_NAME = "java";
    private static final String VERBOSE = "verbose";
    private static final String ONCE_LOGGER = "org.openapitools.codegen.utils.oncelogger.enabled";
    private static final String QUARKUS_API_CLIENT_TEMPLATE = "kogitoQuarkusApiClient.mustache";
    private final KogitoJavaClientCodegen kogitoCodegen;
    private final CodegenConfigurator configurator;
    private final DefaultGenerator generator;

    private OpenApiClientGeneratorWrapper(String specFilePath, String outputDir, String runtime) {
        String customApiTemplate = "";
        if ("Quarkus".equals(runtime)) {
            customApiTemplate = QUARKUS_API_CLIENT_TEMPLATE;
        }
        GlobalSettings.setProperty((String)"apiDocs", (String)FALSE);
        GlobalSettings.setProperty((String)"apiTests", (String)FALSE);
        GlobalSettings.setProperty((String)"modelTests", (String)FALSE);
        GlobalSettings.setProperty((String)"modelDocs", (String)FALSE);
        GlobalSettings.setProperty((String)"apis", (String)"");
        GlobalSettings.setProperty((String)"supportingFiles", (String)"");
        GlobalSettings.setProperty((String)VERBOSE, (String)FALSE);
        GlobalSettings.setProperty((String)ONCE_LOGGER, (String)TRUE);
        this.configurator = new CodegenConfigurator();
        this.configurator.setInputSpec(specFilePath);
        this.configurator.setGeneratorName(GENERATOR_NAME);
        this.generator = new DefaultGenerator();
        this.kogitoCodegen = new KogitoJavaClientCodegen(this.generator, customApiTemplate);
        this.kogitoCodegen.setOutputDir(outputDir);
    }

    public static OpenApiClientGeneratorWrapper newInstance(String specFilePath, String outputDir, KogitoBuildContext context) {
        return new OpenApiClientGeneratorWrapper(specFilePath, outputDir, context.name());
    }

    public OpenApiClientGeneratorWrapper withPackage(String pkg) {
        this.kogitoCodegen.setApiPackage(pkg);
        this.kogitoCodegen.setInvokerPackage(pkg);
        this.kogitoCodegen.setModelPackage(pkg + ".model");
        return this;
    }

    public List<File> generate(OpenApiSpecDescriptor descriptor) {
        List generatedFiles = this.generator.opts(this.configurator.toClientOptInput().config((CodegenConfig)this.kogitoCodegen)).generate();
        this.kogitoCodegen.processGeneratedOperations(descriptor);
        return generatedFiles;
    }
}

