/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.Objects;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenApiSpecMockServer
implements BeforeEachCallback,
AfterEachCallback {
    private static final String SPEC_FILES_PATH = "/specs";
    private static final int PORT = 8989;
    private WireMockServer specServer;

    public void afterEach(ExtensionContext context) {
        if (this.specServer != null) {
            this.specServer.stop();
            this.specServer.verify(WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()).withHeader("Accept", WireMock.containing((String)"application/json")));
        }
    }

    public void beforeEach(ExtensionContext context) {
        this.specServer = new WireMockServer((Options)WireMockConfiguration.options().usingFilesUnderDirectory(Objects.requireNonNull(this.getClass().getResource(SPEC_FILES_PATH)).getPath()).port(8989));
        this.specServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/error.json")).willReturn(WireMock.aResponse().withStatus(400).withBody("{\n   \"status\":400,\n   \"message\":[\n      \"The value of the Accept header 'text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2' is not supported for the operation (supported values: application/json, application/yaml)\"\n   ]\n}")));
        this.specServer.start();
    }
}

