/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.workflow.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public final class ServerlessWorkflowCodegenUtils {
    public static final Set<String> SUPPORTED_SW_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".sw.json", ".sw.yaml", ".sw.yml")));

    private ServerlessWorkflowCodegenUtils() {
    }

    public static OpenApiSpecDescriptor fromSWFunctionDefinition(FunctionDefinition function) {
        Objects.requireNonNull(function.getOperation(), "Operation attribute in the Workflow Function definition can't be null");
        if (function.getOperation().isEmpty()) {
            throw new IllegalArgumentException("Resource can't be empty when creating a new OpenAPISpecResource");
        }
        if (ServerlessWorkflowUtils.isOpenApiOperation((FunctionDefinition)function)) {
            String resource = ServerlessWorkflowUtils.getOpenApiURI((FunctionDefinition)function);
            String operationId = ServerlessWorkflowUtils.getOpenApiOperationId((FunctionDefinition)function);
            return new OpenApiSpecDescriptor(resource, operationId);
        }
        throw new IllegalArgumentException("Resource does not contain operation id");
    }

    public static List<OpenApiSpecDescriptor> fromSWFunctions(Functions functions) {
        ArrayList<OpenApiSpecDescriptor> resources = new ArrayList<OpenApiSpecDescriptor>();
        if (functions == null || functions.getFunctionDefs() == null) {
            return resources;
        }
        functions.getFunctionDefs().stream().filter(ServerlessWorkflowUtils::isOpenApiOperation).map(ServerlessWorkflowCodegenUtils::fromSWFunctionDefinition).forEach(o -> {
            int idx = resources.indexOf(o);
            if (idx >= 0) {
                ((OpenApiSpecDescriptor)resources.get(idx)).addRequiredOperations(o.getRequiredOperations());
            } else {
                resources.add((OpenApiSpecDescriptor)o);
            }
        });
        return resources;
    }

    public static boolean acceptOnlyWithOpenAPIOperation(Workflow workflow) {
        return workflow.getFunctions() != null && workflow.getFunctions().getFunctionDefs() != null && workflow.getFunctions().getFunctionDefs().stream().anyMatch(ServerlessWorkflowUtils::isOpenApiOperation);
    }
}

