/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.di;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import java.io.File;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiClientOperation;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.di.AbstractDependencyInjectionHandler;

public class ServicesConfigurationHandler
extends AbstractDependencyInjectionHandler {
    private static final String API_CLIENT_PARAMETER = "ApiClient";

    protected ServicesConfigurationHandler(KogitoBuildContext context) {
        super(context);
    }

    @Override
    public ClassOrInterfaceDeclaration handle(ClassOrInterfaceDeclaration node, OpenApiSpecDescriptor descriptor, File originalGeneratedFile) {
        if (this.fetchServiceClasses(descriptor).anyMatch(new ClassFileEqualityFilter(originalGeneratedFile))) {
            node.getConstructorByParameterTypes(new String[]{API_CLIENT_PARAMETER}).ifPresent(c -> this.context.getDependencyInjectionAnnotator().withInjection((NodeWithAnnotations)c));
            return (ClassOrInterfaceDeclaration)this.context.getDependencyInjectionAnnotator().withApplicationComponent((NodeWithAnnotations)node);
        }
        return node;
    }

    private Stream<String> fetchServiceClasses(OpenApiSpecDescriptor descriptor) {
        return descriptor.getRequiredOperations().stream().map(OpenApiClientOperation::getGeneratedClass);
    }

    private static class ClassFileEqualityFilter
    implements Predicate<String> {
        private static final String JAVA_EXTENSION = ".java";
        private final File file;

        ClassFileEqualityFilter(File file) {
            this.file = file;
        }

        @Override
        public boolean test(String canonicalClassName) {
            if (this.file == null) {
                return false;
            }
            if (canonicalClassName == null || canonicalClassName.isEmpty()) {
                return false;
            }
            return this.file.toURI().toString().endsWith(canonicalClassName.replace(".", "/") + JAVA_EXTENSION);
        }
    }
}

