/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.codegen.common.GeneratedFile;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.CollectedResourcesTestUtils;
import org.kie.kogito.codegen.openapi.client.OpenApiClientCodegen;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;

class OpenApiClientCodegenTest {
    OpenApiClientCodegenTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        String workflowDefinitionFile = "/sendcloudeventonprovision.sw.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiClientCodegen emptyCodeGenerator = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        OpenApiClientCodegen codeGenerator = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourcesTestUtils.toCollectedResources((String[])new String[]{"/sendcloudeventonprovision.sw.json"}));
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Assertions.assertThat((List)codeGenerator.getOpenAPISpecResources()).hasSizeGreaterThanOrEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void verifyHTTPResource(KogitoBuildContext.Builder contextBuilder) {
        String workflowDefinitionFile = "/sendcloudeventonprovision.sw.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiClientCodegen codegen = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourcesTestUtils.toCollectedResources((String[])new String[]{"/sendcloudeventonprovision.sw.json"}));
        Assertions.assertThat((Object)codegen).isNotNull();
        Assertions.assertThat((List)codegen.getOpenAPISpecResources()).isNotEmpty();
        Assertions.assertThat((List)codegen.getOpenAPISpecResources()).hasSize(1);
        Assertions.assertThat((String)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getResourceName()).isEqualTo("provisioning.json");
        Assertions.assertThat((String)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getId()).contains(new CharSequence[]{"provisioning"});
        Assertions.assertThat((String)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getURI().getScheme()).isEqualTo("http");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void verifyLocalMultipleResources(KogitoBuildContext.Builder contextBuilder) {
        String workflowDefinitionFile = "/sendcloudeventonprovision2.sw.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiClientCodegen codegen = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourcesTestUtils.toCollectedResources((String[])new String[]{"/sendcloudeventonprovision2.sw.json"}));
        Assertions.assertThat((Object)codegen).isNotNull();
        Assertions.assertThat((List)codegen.getOpenAPISpecResources()).isNotEmpty();
        Assertions.assertThat((List)codegen.getOpenAPISpecResources()).hasSize(1);
        Assertions.assertThat((String)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getResourceName()).isEqualTo("provisioning.json");
        Assertions.assertThat((String)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getId()).contains(new CharSequence[]{"provisioning"});
        Assertions.assertThat((String)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getURI().getScheme()).isNull();
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void verifyCodegenClasspath(KogitoBuildContext.Builder contextBuilder) {
        String workflowDefinitionFile = "/petstore-classpath.sw.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiClientCodegen codegen = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourcesTestUtils.toCollectedResources((String[])new String[]{"/petstore-classpath.sw.json"}));
        this.assertCodeGen(codegen.generate(), Collections.singletonList("Pet"));
        Assertions.assertThat((List)codegen.getOpenAPISpecResources()).hasSize(1);
        Assertions.assertThat((Collection)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getRequiredOperations()).hasSize(2);
        Assertions.assertThat((boolean)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getRequiredOperations().stream().anyMatch(o -> o.getOperationId().equals("getInventory") && o.getParameters().size() == 0 && o.getGeneratedClass().endsWith("StoreApi"))).isTrue();
        Assertions.assertThat((boolean)((OpenApiSpecDescriptor)codegen.getOpenAPISpecResources().get(0)).getRequiredOperations().stream().anyMatch(o -> o.getOperationId().equals("uploadFile") && o.getParameters().size() == 3 && o.getGeneratedClass().endsWith("PetApi"))).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void verifyCodegenWithSecurityApiKey(KogitoBuildContext.Builder contextBuilder) {
        String workflowDefinitionFile = "/weatherdata.sw.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiClientCodegen codegen = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourcesTestUtils.toCollectedResources((String[])new String[]{"/weatherdata.sw.json"}));
        Assertions.assertThat((List)codegen.getOpenAPISpecResources()).hasSize(1);
        Collection files = codegen.generate();
        this.assertCodeGen(files, Collections.singletonList("CurrentWeatherData"));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void verifyCodegenV2WithSecurityApiKey(KogitoBuildContext.Builder contextBuilder) {
        String workflowDefinitionFile = "/openapi2-sec.sw.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiClientCodegen codegen = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourcesTestUtils.toCollectedResources((String[])new String[]{"/openapi2-sec.sw.json"}));
        Assertions.assertThat((List)codegen.getOpenAPISpecResources()).hasSize(1);
        Collection files = codegen.generate();
        this.assertCodeGen(files, Collections.singletonList("Myapp"));
    }

    private void assertCodeGen(Collection<GeneratedFile> generatedFiles, List<String> requiredModel) {
        Assertions.assertThat(generatedFiles).isNotEmpty();
        HashMap<String, Boolean> requiredFiles = new HashMap<String, Boolean>();
        requiredFiles.put("ApiClient.java", false);
        requiredFiles.put("KogitoApiClient.java", false);
        requiredFiles.put("ApiKeyAuth.java", false);
        HashMap<String, Boolean> absentFiles = new HashMap<String, Boolean>();
        requiredModel.forEach(f -> {
            requiredFiles.put(f + "Api.java", false);
            absentFiles.put(f + ".api", false);
        });
        for (GeneratedFile file2 : generatedFiles) {
            Assertions.assertThat((String)file2.relativePath()).endsWith((CharSequence)".java");
            String fileName = Paths.get(file2.relativePath(), new String[0]).getFileName().toString();
            requiredFiles.computeIfPresent(fileName, (k, v) -> true);
            absentFiles.computeIfPresent(fileName, (k, v) -> true);
        }
        Assertions.assertThat(requiredFiles).allSatisfy((file, present) -> Assertions.assertThat((Boolean)present).isTrue());
        Assertions.assertThat(absentFiles).allSatisfy((file, present) -> Assertions.assertThat((Boolean)present).isFalse());
    }
}

