/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import org.drools.core.util.StringUtils;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiClientException;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.di.DependencyInjectionConfigurer;

public class GeneratedFileBuilder {
    private final KogitoBuildContext context;
    private final DependencyInjectionConfigurer dependencyInjectionConfigurer;

    protected GeneratedFileBuilder(KogitoBuildContext context) {
        this.context = context;
        this.dependencyInjectionConfigurer = new DependencyInjectionConfigurer(context);
    }

    public GeneratedFile build(File file, OpenApiSpecDescriptor descriptor) {
        if (this.context.hasDI()) {
            return this.toGeneratedFile(this.getGeneratedFilePath(file), this.dependencyInjectionConfigurer.parseAndConfigure(file, descriptor).toString());
        }
        return this.toGeneratedFile(file);
    }

    private GeneratedFile toGeneratedFile(String path, String content) {
        return new GeneratedFile(GeneratedFileType.SOURCE, path, content);
    }

    private GeneratedFile toGeneratedFile(File file) {
        return this.toGeneratedFile(this.getGeneratedFilePath(file), this.readFileContent(file));
    }

    private String getGeneratedFilePath(File openAPIGeneratorFile) {
        Path path = openAPIGeneratorFile.toPath();
        for (int i = 0; i < path.getNameCount(); ++i) {
            if (!"src".equals(path.getName(i).toString())) continue;
            return path.subpath(i, path.getNameCount()).toString().replace("src/main/java/", "");
        }
        return "";
    }

    private String readFileContent(File file) {
        String string;
        block8: {
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            try {
                string = StringUtils.readFileAsString((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new OpenApiClientException("Fail to read generated OpenAPI file: " + file.toPath(), e);
                }
            }
            reader.close();
        }
        return string;
    }
}

