/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.workflow.BaseWorkflow;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.util.StringUtils;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.io.CollectedResource;
import org.kie.kogito.codegen.core.AbstractGenerator;
import org.kie.kogito.codegen.openapi.client.GeneratedFileBuilder;
import org.kie.kogito.codegen.openapi.client.OpenApiClientParsingException;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.OpenApiUtils;
import org.kie.kogito.codegen.openapi.client.ServerlessWorkflowCodegenUtils;
import org.kie.kogito.codegen.openapi.client.generator.OpenApiClientGeneratorWrapper;
import org.kie.kogito.codegen.openapi.client.io.PathResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiClientCodegen
extends AbstractGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiClientCodegen.class);
    private static final String BASE_PACKAGE = "openapi.client";
    private static final String GEN_BASE_PATH = "openapi";
    private static final int PRIORITY = 1;
    private final List<OpenApiSpecDescriptor> openApiSpecDescriptors;
    private final GeneratedFileBuilder fileBuilder;

    private OpenApiClientCodegen(KogitoBuildContext context, String name, List<OpenApiSpecDescriptor> openApiSpecDescriptors) {
        super(context, name);
        this.fileBuilder = new GeneratedFileBuilder(context);
        this.openApiSpecDescriptors = openApiSpecDescriptors == null ? Collections.emptyList() : openApiSpecDescriptors;
    }

    public static OpenApiClientCodegen ofCollectedResources(KogitoBuildContext context, Collection<CollectedResource> resources) {
        List<OpenApiSpecDescriptor> openApiSpecDescriptors = resources.stream().map(CollectedResource::resource).flatMap(resource -> ServerlessWorkflowCodegenUtils.SUPPORTED_SW_EXTENSIONS.stream().filter(ext -> resource.getSourcePath().endsWith((String)ext)).map(e -> {
            Workflow workflow;
            block8: {
                Reader reader = resource.getReader();
                try {
                    workflow = BaseWorkflow.fromSource((String)StringUtils.readFileAsString((Reader)reader));
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new OpenApiClientParsingException("Failed to parse Serverless Workflow file " + resource.getSourcePath(), ex);
                    }
                }
                reader.close();
            }
            return workflow;
        })).filter(ServerlessWorkflowCodegenUtils::acceptOnlyWithOpenAPIOperation).map(workflow -> ServerlessWorkflowCodegenUtils.fromSWFunctions(workflow.getFunctions())).flatMap(Collection::stream).collect(Collectors.toList());
        return new OpenApiClientCodegen(context, "openapispecs", openApiSpecDescriptors);
    }

    public int priority() {
        return 1;
    }

    public List<OpenApiSpecDescriptor> getOpenAPISpecResources() {
        return this.openApiSpecDescriptors;
    }

    public Optional<ApplicationSection> section() {
        return Optional.empty();
    }

    public Collection<GeneratedFile> generate() {
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        this.openApiSpecDescriptors.forEach(descriptor -> {
            LOGGER.debug("Generating OpenApi classes based on {}", (Object)descriptor.getResourceName());
            String openApiGeneratorOutputDir = this.getOutputDirForOpenAPIGen((OpenApiSpecDescriptor)descriptor);
            try {
                String resolvedPath = PathResolverFactory.newResolver(descriptor, this.context()).resolve((OpenApiSpecDescriptor)descriptor);
                List files = OpenApiClientGeneratorWrapper.newInstance(resolvedPath, openApiGeneratorOutputDir).withPackage(this.getBasePackageFor((OpenApiSpecDescriptor)descriptor)).generate((OpenApiSpecDescriptor)descriptor).stream().filter(f -> f.toPath().toString().toLowerCase().endsWith(".java")).map(f -> this.fileBuilder.build((File)f, (OpenApiSpecDescriptor)descriptor)).collect(Collectors.toList());
                generatedFiles.addAll(files);
            }
            finally {
                this.cleanOpenApiGeneratorCode(openApiGeneratorOutputDir);
            }
        });
        this.context().addContextAttribute("openApiDescriptor", this.openApiSpecDescriptors);
        return generatedFiles;
    }

    private void cleanOpenApiGeneratorCode(String outputDir) {
        try (Stream<Path> files = Files.walk(Paths.get(outputDir, new String[0]), new FileVisitOption[0]);){
            files.sorted(Comparator.reverseOrder()).map(Path::toFile).filter(File::exists).forEach(File::delete);
        }
        catch (IOException e) {
            LOGGER.warn("Impossible to clean up OpenApi generator output dir", (Throwable)e);
        }
    }

    private String getBasePackageFor(OpenApiSpecDescriptor resource) {
        return this.context().getPackageName() + "." + BASE_PACKAGE + "." + resource.getId();
    }

    private String getOutputDirForOpenAPIGen(OpenApiSpecDescriptor resource) {
        return String.join((CharSequence)"/", OpenApiUtils.getEndUserTargetDir(this.context()), GEN_BASE_PATH, resource.getId());
    }
}

