/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;

public final class OpenApiUtils {
    private OpenApiUtils() {
    }

    public static String getEndUserTargetDir(KogitoBuildContext context) {
        Path classesPath;
        if (context.getAppPaths().hasClassesPaths() && (classesPath = context.getAppPaths().getFirstClassesPath()).endsWith(Paths.get("target", new String[0]))) {
            return classesPath.toString();
        }
        if (context.getAppPaths().hasProjectPaths()) {
            return context.getAppPaths().getFirstProjectPath().resolve("target").toString();
        }
        throw new IllegalStateException("No valid paths found in the current application path: " + context.getAppPaths());
    }

    public static void requireValidSpecURI(OpenApiSpecDescriptor resource) {
        Objects.requireNonNull(resource, "OpenApiSpecDescriptor can't be null");
        Objects.requireNonNull(resource.getURI(), "URI in OpenApiSpecDescriptor is null");
        if (resource.getURI().getPath().equals("")) {
            throw new IllegalArgumentException("Invalid OpenAPI spec file path: " + resource);
        }
    }
}

