/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.di;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiClientException;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.di.ApplicationPropertiesHandler;
import org.kie.kogito.codegen.openapi.client.di.ServicesConfigurationHandler;

public class DependencyInjectionConfigurer {
    private final ServicesConfigurationHandler servicesConfigurationHandler;
    private final ApplicationPropertiesHandler applicationPropertiesHandler;

    public DependencyInjectionConfigurer(KogitoBuildContext context) {
        this.servicesConfigurationHandler = new ServicesConfigurationHandler(context);
        this.applicationPropertiesHandler = new ApplicationPropertiesHandler(context);
    }

    public CompilationUnit parseAndConfigure(File originalGeneratedFile, OpenApiSpecDescriptor descriptor) {
        try {
            CompilationUnit compilationUnit = StaticJavaParser.parse((File)originalGeneratedFile);
            Optional clazz = compilationUnit.findFirst(ClassOrInterfaceDeclaration.class);
            if (clazz.isPresent()) {
                this.servicesConfigurationHandler.handle((ClassOrInterfaceDeclaration)clazz.get(), descriptor, originalGeneratedFile);
                this.applicationPropertiesHandler.handle((ClassOrInterfaceDeclaration)clazz.get(), descriptor, originalGeneratedFile);
            }
            return compilationUnit;
        }
        catch (FileNotFoundException e) {
            throw new OpenApiClientException("Failed to add process dependency injection configuration to OpenApi generated file: " + originalGeneratedFile, e);
        }
    }
}

