/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.rules;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.DecisionTableProvider;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.KogitoContextTestUtils;
import org.kie.kogito.codegen.core.DashboardGeneratedFileUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.codegen.rules.MissingDecisionTableDependencyError;
import org.kie.kogito.codegen.rules.RuleCodegenError;

public class IncrementalRuleCodegenTest {
    private static final String RESOURCE_PATH = "src/test/resources";

    @BeforeEach
    public void setup() {
        DecisionTableFactory.setDecisionTableProvider((DecisionTableProvider)((DecisionTableProvider)ServiceRegistry.getInstance().get(DecisionTableProvider.class)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        KogitoBuildContext context = contextBuilder.build();
        IncrementalRuleCodegen emptyCodeGenerator = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        IncrementalRuleCodegen codeGenerator = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl"));
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSingleFile(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        IncrementalRuleCodegenTest.assertRules(5, 1, generatedFiles.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSinglePackage(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1").listFiles());
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        IncrementalRuleCodegenTest.assertRules(7, 1, generatedFiles.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSinglePackageSingleUnit(KogitoBuildContext.Builder contextBuilder) {
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/multiunit").listFiles());
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnit.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnitInstance.java")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateDirectoryRecursively(KogitoBuildContext.Builder contextBuilder) {
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromPaths(contextBuilder, Paths.get("src/test/resources/org/kie/kogito/codegen/rules", new String[0]));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnit.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnitInstance.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnit.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnitInstance.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/singleton/SingletonRuleUnit.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/singleton/SingletonRuleUnitInstance.java")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSingleDtable(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/candrink/CanDrink.xls"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        int externalizedLambda = 5;
        int legacyApiFiles = 2;
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda - legacyApiFiles);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSingleUnit(KogitoBuildContext.Builder contextBuilder) {
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/myunit").listFiles());
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnit.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnitInstance.java")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateCepRule(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/cep/cep.drl"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        int externalizedLambda = 2;
        int legacyApiFiles = 2;
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda - legacyApiFiles);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void raiseErrorOnSyntaxError(KogitoBuildContext.Builder contextBuilder) {
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/broken.drl"));
        org.junit.jupiter.api.Assertions.assertThrows(RuleCodegenError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void raiseErrorOnBadOOPath(KogitoBuildContext.Builder contextBuilder) {
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/brokenrules/brokenunit/ABrokenUnit.drl"));
        org.junit.jupiter.api.Assertions.assertThrows(RuleCodegenError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void throwWhenDtableDependencyMissing(KogitoBuildContext.Builder contextBuilder) {
        DecisionTableFactory.setDecisionTableProvider(null);
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/candrink/CanDrink.xls"));
        org.junit.jupiter.api.Assertions.assertThrows(MissingDecisionTableDependencyError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateGrafanaDashboards(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withAddonsConfig(AddonsConfig.builder().withPrometheusMonitoring(true).withMonitoring(true).build());
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl"));
        int expectedDashboards = contextBuilder.build().hasRESTForGenerator((Generator)incrementalRuleCodegen) ? 3 : 1;
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedDashboards, (long)generatedFiles.stream().filter(x -> x.type().equals(DashboardGeneratedFileUtils.DASHBOARD_TYPE)).count());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void elapsedTimeMonitoringIsWrappingEveryMethod(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withAddonsConfig(AddonsConfig.builder().withPrometheusMonitoring(true).withMonitoring(true).build()).build();
        IncrementalRuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        List endpointClasses = generatedFiles.stream().filter(x -> x.relativePath().contains("Endpoint")).map(x -> new String(x.contents())).collect(Collectors.toList());
        for (String endpointClass : endpointClasses) {
            IncrementalRuleCodegenTest.assertMonitoringEndpoints(endpointClass);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void missingLegacyApi(KogitoBuildContext.Builder contextBuilder) {
        IncrementalRuleCodegen codeGenerator = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((IncrementalRuleCodegen)codeGenerator).generate()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("kogito-legacy-api");
    }

    private void assertHasLegacyApiFiles(Collection<GeneratedFile> generatedFiles) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().endsWith("/ProjectModel.java")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().endsWith("/ProjectRuntime.java")));
    }

    private IncrementalRuleCodegen getIncrementalRuleCodegenFromFiles(KogitoBuildContext.Builder contextBuilder, File ... resources) {
        return IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)contextBuilder.build(), (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get(RESOURCE_PATH, new String[0]), (File[])resources));
    }

    private IncrementalRuleCodegen getIncrementalRuleCodegenFromPaths(KogitoBuildContext.Builder contextBuilder, Path ... paths) {
        return IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)contextBuilder.build(), (Collection)CollectedResourceProducer.fromPaths((Path[])paths));
    }

    private static void assertMonitoringEndpoints(String endpointClass) {
        CompilationUnit cu = StaticJavaParser.parse((String)endpointClass);
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)cu.findFirst(ClassOrInterfaceDeclaration.class).get();
        ReturnStmt executeQueryReturnStmt = (ReturnStmt)((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQuery").get(0)).getBody().orElseThrow(() -> new RuntimeException("No body found for executeQuery method"))).findFirst(ReturnStmt.class).orElseThrow(() -> new RuntimeException("No return statement for executeQuery method. Template has changed."));
        ReturnStmt executeQueryFirstReturnStmt = (ReturnStmt)((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQueryFirst").get(0)).getBody().orElseThrow(() -> new RuntimeException("No body found for executeQueryFirst method"))).findFirst(ReturnStmt.class).orElseThrow(() -> new RuntimeException("No return statement for executeQueryFirst method. Template has changed."));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clazz.getFieldByName("systemMetricsCollectorProvider").isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Expression)executeQueryReturnStmt.getExpression().get()).isMethodCallExpr());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Expression)executeQueryFirstReturnStmt.getExpression().get()).isMethodCallExpr());
        String statementsExecuteQuery = ((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQuery").get(0)).getBody().get()).getStatements().toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQuery.contains("startTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQuery.contains("endTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQuery.contains("registerElapsedTimeSampleMetrics"));
        String statementsExecuteQueryFirst = ((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQueryFirst").get(0)).getBody().get()).getStatements().toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("startTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("endTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("registerElapsedTimeSampleMetrics"));
    }

    private static void assertRules(int expectedRules, int expectedPackages, int actualGeneratedFiles) {
        org.junit.jupiter.api.Assertions.assertEquals((int)(expectedRules + expectedPackages * 2), (int)actualGeneratedFiles);
    }
}

