/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.rules;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.codegen.common.GeneratedFile;
import org.drools.drl.extensions.DecisionTableFactory;
import org.drools.drl.extensions.DecisionTableProvider;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.internal.utils.KieService;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.KogitoContextTestUtils;
import org.kie.kogito.codegen.core.DashboardGeneratedFileUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.rules.MissingDecisionTableDependencyError;
import org.kie.kogito.codegen.rules.RuleCodegen;
import org.kie.kogito.codegen.rules.RuleCodegenError;

public class RuleCodegenTest {
    private static final String RESOURCE_PATH = "src/test/resources";

    @BeforeEach
    public void setup() {
        DecisionTableFactory.setDecisionTableProvider((DecisionTableProvider)((DecisionTableProvider)KieService.load(DecisionTableProvider.class)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        KogitoBuildContext context = contextBuilder.build();
        RuleCodegen emptyCodeGenerator = RuleCodegen.ofCollectedResources((KogitoBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        RuleCodegen codeGenerator = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl"));
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSingleFile(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        RuleCodegenTest.assertRules(5, 1, generatedFiles.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSinglePackage(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1").listFiles());
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        RuleCodegenTest.assertRules(7, 1, generatedFiles.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSinglePackageSingleUnit(KogitoBuildContext.Builder contextBuilder) {
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/multiunit").listFiles());
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnit.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnitInstance.java"));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateDirectoryRecursively(KogitoBuildContext.Builder contextBuilder) {
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromPaths(contextBuilder, Paths.get("src/test/resources/org/kie/kogito/codegen/rules", new String[0]));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnit.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnitInstance.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnit.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnitInstance.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/singleton/SingletonRuleUnit.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/singleton/SingletonRuleUnitInstance.java"));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSingleDtable(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/candrink/CanDrink.drl.xls"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        int externalizedLambda = 5;
        int legacyApiFiles = 2;
        RuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda - legacyApiFiles);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateSingleUnit(KogitoBuildContext.Builder contextBuilder) {
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/rules/myunit").listFiles());
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnit.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnitInstance.java"));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateCepRule(KogitoBuildContext.Builder contextBuilder) {
        KogitoContextTestUtils.withLegacyApi((KogitoBuildContext.Builder)contextBuilder);
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/cep/cep.drl"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        int externalizedLambda = 2;
        int legacyApiFiles = 2;
        RuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda - legacyApiFiles);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void raiseErrorOnSyntaxError(KogitoBuildContext.Builder contextBuilder) {
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/broken.drl"));
        Assertions.assertThatThrownBy(() -> ((RuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate()).isInstanceOf(RuleCodegenError.class);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void raiseErrorOnBadOOPath(KogitoBuildContext.Builder contextBuilder) {
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/brokenrules/brokenunit/ABrokenUnit.drl"));
        Assertions.assertThatThrownBy(() -> ((RuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate()).isInstanceOf(RuleCodegenError.class);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void throwWhenDtableDependencyMissing(KogitoBuildContext.Builder contextBuilder) {
        DecisionTableFactory.setDecisionTableProvider(null);
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/candrink/CanDrink.drl.xls"));
        Assertions.assertThatThrownBy(() -> ((RuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate()).isInstanceOf(MissingDecisionTableDependencyError.class);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateGrafanaDashboards(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withAddonsConfig(AddonsConfig.builder().withPrometheusMonitoring(true).withMonitoring(true).build());
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl"));
        int expectedDashboards = contextBuilder.build().hasRESTForGenerator((Generator)incrementalRuleCodegen) ? 3 : 1;
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertThat(generatedFiles.stream().filter(x -> x.type().equals(DashboardGeneratedFileUtils.DASHBOARD_TYPE))).hasSize(expectedDashboards);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateGrafanaDashboardsExcluded(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withAddonsConfig(AddonsConfig.builder().withPrometheusMonitoring(true).withMonitoring(true).build());
        KogitoBuildContext context = contextBuilder.build();
        context.setApplicationProperty("kogito.grafana.disabled.operational.dashboards", "find-adults,find-adults-age");
        context.setApplicationProperty("kogito.grafana.disabled.domain.dashboards", "AdultUnit");
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(context, new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertThat(generatedFiles.stream().filter(x -> x.type().equals(DashboardGeneratedFileUtils.DASHBOARD_TYPE))).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void elapsedTimeMonitoringIsWrappingEveryMethod(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withAddonsConfig(AddonsConfig.builder().withPrometheusMonitoring(true).withMonitoring(true).build()).build();
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl"));
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        List endpointClasses = generatedFiles.stream().filter(x -> x.relativePath().contains("Endpoint")).map(x -> new String(x.contents())).collect(Collectors.toList());
        for (String endpointClass : endpointClasses) {
            RuleCodegenTest.assertMonitoringEndpoints(endpointClass);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void noObjectMapperWhenNoRest(KogitoBuildContext.Builder contextBuilder) {
        RuleCodegen incrementalRuleCodegen = this.getIncrementalRuleCodegenFromFiles(contextBuilder.build(), new File("src/test/resources/org/kie/kogito/codegen/rules/myunit").listFiles());
        Collection generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertThat((Collection)generatedFiles).hasSizeGreaterThan(0);
        if (contextBuilder.build().hasRESTGloballyAvailable()) {
            Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().endsWith("KogitoObjectMapper.java"));
        } else {
            Assertions.assertThat(generatedFiles.stream()).noneMatch(f -> f.relativePath().endsWith("KogitoObjectMapper.java"));
        }
    }

    private void assertHasLegacyApiFiles(Collection<GeneratedFile> generatedFiles) {
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().endsWith("/ProjectModel.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().endsWith("/ProjectRuntime.java"));
    }

    private RuleCodegen getIncrementalRuleCodegenFromFiles(KogitoBuildContext.Builder contextBuilder, File ... resources) {
        return this.getIncrementalRuleCodegenFromFiles(contextBuilder.build(), resources);
    }

    private RuleCodegen getIncrementalRuleCodegenFromFiles(KogitoBuildContext context, File ... resources) {
        return RuleCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get(RESOURCE_PATH, new String[0]), (File[])resources));
    }

    private RuleCodegen getIncrementalRuleCodegenFromPaths(KogitoBuildContext.Builder contextBuilder, Path ... paths) {
        return RuleCodegen.ofCollectedResources((KogitoBuildContext)contextBuilder.build(), (Collection)CollectedResourceProducer.fromPaths((Path[])paths));
    }

    private static void assertMonitoringEndpoints(String endpointClass) {
        CompilationUnit cu = StaticJavaParser.parse((String)endpointClass);
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)cu.findFirst(ClassOrInterfaceDeclaration.class).get();
        ReturnStmt executeQueryReturnStmt = (ReturnStmt)((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQuery").get(0)).getBody().orElseThrow(() -> new RuntimeException("No body found for executeQuery method"))).findFirst(ReturnStmt.class).orElseThrow(() -> new RuntimeException("No return statement for executeQuery method. Template has changed."));
        ReturnStmt executeQueryFirstReturnStmt = (ReturnStmt)((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQueryFirst").get(0)).getBody().orElseThrow(() -> new RuntimeException("No body found for executeQueryFirst method"))).findFirst(ReturnStmt.class).orElseThrow(() -> new RuntimeException("No return statement for executeQueryFirst method. Template has changed."));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clazz.getFieldByName("systemMetricsCollectorProvider").isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Expression)executeQueryReturnStmt.getExpression().get()).isMethodCallExpr());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Expression)executeQueryFirstReturnStmt.getExpression().get()).isMethodCallExpr());
        String statementsExecuteQuery = ((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQuery").get(0)).getBody().get()).getStatements().toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQuery.contains("startTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQuery.contains("endTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQuery.contains("registerElapsedTimeSampleMetrics"));
        String statementsExecuteQueryFirst = ((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQueryFirst").get(0)).getBody().get()).getStatements().toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("startTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("endTime"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("registerElapsedTimeSampleMetrics"));
    }

    private static void assertRules(int expectedRules, int expectedPackages, int actualGeneratedFiles) {
        int expectedFiles = expectedRules + expectedPackages * 2;
        Assertions.assertThat((int)actualGeneratedFiles).isEqualTo(expectedFiles);
    }
}

