/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.rules;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.DecisionTableProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.core.DashboardGeneratedFileUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.codegen.rules.MissingDecisionTableDependencyError;
import org.kie.kogito.codegen.rules.RuleCodegenError;

public class IncrementalRuleCodegenTest {
    private static final KogitoBuildContext ACME_CONTEXT = JavaKogitoBuildContext.builder().withPackageName("com.acme").build();

    @BeforeEach
    public void setup() {
        DecisionTableFactory.setDecisionTableProvider((DecisionTableProvider)((DecisionTableProvider)ServiceRegistry.getInstance().get(DecisionTableProvider.class)));
    }

    @Test
    public void generateSingleFile() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl")}));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(3, 1, generatedFiles.size());
    }

    @Test
    public void generateSinglePackage() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1").listFiles()));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(5, 1, generatedFiles.size());
    }

    @Test
    public void generateSinglePackageSingleUnit() {
        KogitoBuildContext context = JavaKogitoBuildContext.builder().withPackageName("org.kie.kogito.codegen.rules.multiunit").build();
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File("src/test/resources/org/kie/kogito/codegen/rules/multiunit").listFiles()));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnit.java")));
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnitInstance.java")));
    }

    @Test
    public void generateDirectoryRecursively() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/org/kie/kogito/codegen/rules", new String[0])}));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnit.java")));
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/multiunit/MultiUnitRuleUnitInstance.java")));
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnit.java")));
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnitInstance.java")));
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/singleton/SingletonRuleUnit.java")));
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/singleton/SingletonRuleUnitInstance.java")));
    }

    @Test
    public void generateSingleDtable() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/drools/simple/candrink/CanDrink.xls")}));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        int externalizedLambda = 5;
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda);
    }

    @Test
    public void generateSingleUnit() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/org/kie/kogito/codegen/rules/myunit", new String[0])}));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnit.java")));
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(f -> f.relativePath().equals("org/kie/kogito/codegen/rules/myunit/MyUnitRuleUnitInstance.java")));
    }

    @Test
    public void generateCepRule() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/drools/simple/cep/cep.drl")}));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        int externalizedLambda = 2;
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda);
    }

    @Test
    public void raiseErrorOnSyntaxError() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/drools/simple/broken.drl")}));
        Assertions.assertThrows(RuleCodegenError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @Test
    public void raiseErrorOnBadOOPath() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/kie/kogito/codegen/brokenrules/brokenunit/ABrokenUnit.drl")}));
        Assertions.assertThrows(RuleCodegenError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @Test
    public void throwWhenDtableDependencyMissing() {
        DecisionTableFactory.setDecisionTableProvider(null);
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)ACME_CONTEXT, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/drools/simple/candrink/CanDrink.xls")}));
        Assertions.assertThrows(MissingDecisionTableDependencyError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateGrafanaDashboards(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAddonsConfig(AddonsConfig.builder().withPrometheusMonitoring(true).withMonitoring(true).build()).build();
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl")}));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertEquals((long)2L, (long)generatedFiles.stream().filter(x -> x.type().equals(DashboardGeneratedFileUtils.DASHBOARD_TYPE)).count());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void elapsedTimeMonitoringIsWrappingEveryMethod(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAddonsConfig(AddonsConfig.builder().withPrometheusMonitoring(true).withMonitoring(true).build()).build();
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)Paths.get("src/test/resources", new String[0]), (File[])new File[]{new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl")}));
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        List endpointClasses = generatedFiles.stream().filter(x -> x.relativePath().contains("Endpoint")).map(x -> new String(x.contents())).collect(Collectors.toList());
        for (String endpointClass : endpointClasses) {
            IncrementalRuleCodegenTest.assertMonitoringEndpoints(endpointClass);
        }
    }

    private static void assertMonitoringEndpoints(String endpointClass) {
        CompilationUnit cu = StaticJavaParser.parse((String)endpointClass);
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)cu.findFirst(ClassOrInterfaceDeclaration.class).get();
        ReturnStmt executeQueryReturnStmt = (ReturnStmt)((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQuery").get(0)).getBody().orElseThrow(() -> new RuntimeException("No body found for executeQuery method"))).findFirst(ReturnStmt.class).orElseThrow(() -> new RuntimeException("No return statement for executeQuery method. Template has changed."));
        ReturnStmt executeQueryFirstReturnStmt = (ReturnStmt)((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQueryFirst").get(0)).getBody().orElseThrow(() -> new RuntimeException("No body found for executeQueryFirst method"))).findFirst(ReturnStmt.class).orElseThrow(() -> new RuntimeException("No return statement for executeQueryFirst method. Template has changed."));
        Assertions.assertFalse((boolean)((Expression)executeQueryReturnStmt.getExpression().get()).isMethodCallExpr());
        Assertions.assertFalse((boolean)((Expression)executeQueryFirstReturnStmt.getExpression().get()).isMethodCallExpr());
        String statementsExecuteQuery = ((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQuery").get(0)).getBody().get()).getStatements().toString();
        Assertions.assertTrue((boolean)statementsExecuteQuery.contains("startTime"));
        Assertions.assertTrue((boolean)statementsExecuteQuery.contains("endTime"));
        Assertions.assertTrue((boolean)statementsExecuteQuery.contains("registerElapsedTimeSampleMetrics"));
        String statementsExecuteQueryFirst = ((BlockStmt)((MethodDeclaration)clazz.getMethodsByName("executeQueryFirst").get(0)).getBody().get()).getStatements().toString();
        Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("startTime"));
        Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("endTime"));
        Assertions.assertTrue((boolean)statementsExecuteQueryFirst.contains("registerElapsedTimeSampleMetrics"));
    }

    private static void assertRules(int expectedRules, int expectedPackages, int expectedUnits, int actualGeneratedFiles) {
        Assertions.assertEquals((int)(expectedRules + expectedPackages * 2 + expectedUnits * 3), (int)actualGeneratedFiles);
    }

    private static void assertRules(int expectedRules, int expectedPackages, int actualGeneratedFiles) {
        Assertions.assertEquals((int)(expectedRules + expectedPackages * 2), (int)(actualGeneratedFiles - 2));
    }
}

