/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.sample.core;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.sample.core.SampleConfig;
import org.kie.kogito.codegen.sample.core.SampleModel;
import org.kie.kogito.codegen.sample.core.SampleModelImpl;
import org.kie.kogito.codegen.sample.core.SampleRuntime;

public class SampleRuntimeImpl
implements SampleRuntime {
    protected final Map<String, String> rawContent = new HashMap<String, String>();
    protected SampleConfig config;

    public SampleRuntimeImpl() {
    }

    public SampleRuntimeImpl(Application application) {
        this.initApplication(application);
    }

    protected void initApplication(Application application) {
        this.config = (SampleConfig)application.config().get(SampleConfig.class);
    }

    protected void setConfig(SampleConfig config) {
        this.config = config;
    }

    public void addModels(Map<String, String> content) {
        this.rawContent.putAll(content);
    }

    @Override
    public SampleModel getModel(String name) {
        if (!this.rawContent.containsKey(name)) {
            throw new IllegalArgumentException("Impossible to find " + name);
        }
        if (this.config == null) {
            throw new IllegalStateException("No SampleConfig instance provided");
        }
        return new SampleModelImpl(name, this.rawContent.get(name), this.config.numberOfCopy());
    }
}

