/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.jsonpath;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.jsonpath.JsonNodeJsonPathResolver;
import org.mockito.Mockito;

class JsonNodeJsonPathResolverTest {
    final ObjectMapper mapper = new ObjectMapper();
    private KogitoWorkItem workItem;

    JsonNodeJsonPathResolverTest() {
    }

    @BeforeEach
    void setup() {
        this.workItem = (KogitoWorkItem)Mockito.mock(KogitoWorkItem.class);
    }

    @Test
    void verifyMultipleBranchesNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        Mockito.when((Object)this.workItem.getParameter("pepe")).thenReturn((Object)inputModel);
        String parameterDefinition = "{\n   \"SubtractionOperation\":{\n      \"leftElement\":\"$.fahrenheit\",\n      \"rightElement\":\"$.subtractValue\"\n   }\n}";
        JsonNodeJsonPathResolver resolver = new JsonNodeJsonPathResolver("{\n   \"SubtractionOperation\":{\n      \"leftElement\":\"$.fahrenheit\",\n      \"rightElement\":\"$.subtractValue\"\n   }\n}", "pepe");
        JsonNode processedNode = (JsonNode)resolver.apply(this.workItem);
        MatcherAssert.assertThat((Object)processedNode.get("SubtractionOperation").get("leftElement").asInt(), (Matcher)Matchers.is((Object)32));
        MatcherAssert.assertThat((Object)processedNode.get("SubtractionOperation").get("rightElement").asInt(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    void verifyArrayNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        Mockito.when((Object)this.workItem.getParameter("pepe")).thenReturn((Object)inputModel);
        String parameterDefinition = "[\n   {\n      \"leftElement\":\"$.fahrenheit\"\n   },\n   {\n      \"rightElement\":\"$.subtractValue\"\n   }\n]";
        JsonNodeJsonPathResolver resolver = new JsonNodeJsonPathResolver("[\n   {\n      \"leftElement\":\"$.fahrenheit\"\n   },\n   {\n      \"rightElement\":\"$.subtractValue\"\n   }\n]", "pepe");
        JsonNode processedNode = (JsonNode)resolver.apply(this.workItem);
        Assertions.assertTrue((boolean)processedNode.isArray());
        MatcherAssert.assertThat((Object)processedNode.findValue("leftElement").asInt(), (Matcher)Matchers.equalTo((Object)32));
        MatcherAssert.assertThat((Object)processedNode.findValue("rightElement").asInt(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    void verifyValueNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        Mockito.when((Object)this.workItem.getParameter("pepe")).thenReturn((Object)inputModel);
        String parameterDefinition = "\"$.fahrenheit\"";
        JsonNodeJsonPathResolver resolver = new JsonNodeJsonPathResolver("\"$.fahrenheit\"", "pepe");
        JsonNode processedNode = (JsonNode)resolver.apply(this.workItem);
        Assertions.assertTrue((boolean)processedNode.isValueNode());
        MatcherAssert.assertThat((Object)processedNode.asInt(), (Matcher)Matchers.equalTo((Object)32));
    }

    @Test
    void verifyArrayValueNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        Mockito.when((Object)this.workItem.getParameter("pepe")).thenReturn((Object)inputModel);
        String parameterDefinition = "[\"$.fahrenheit\", \"$.subtractValue\"]";
        JsonNodeJsonPathResolver resolver = new JsonNodeJsonPathResolver("[\"$.fahrenheit\", \"$.subtractValue\"]", "pepe");
        JsonNode processedNode = (JsonNode)resolver.apply(this.workItem);
        Assertions.assertTrue((boolean)processedNode.isArray());
        MatcherAssert.assertThat((Object)processedNode.get(0).asInt(), (Matcher)Matchers.equalTo((Object)32));
        MatcherAssert.assertThat((Object)processedNode.get(1).asInt(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    void verifyParameterAsJsonPath() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        Mockito.when((Object)this.workItem.getParameter("pepe")).thenReturn((Object)inputModel);
        String parameterDefinition = "$.fahrenheit";
        JsonNodeJsonPathResolver resolver = new JsonNodeJsonPathResolver("$.fahrenheit", "pepe");
        JsonNode processedNode = (JsonNode)resolver.apply(this.workItem);
        Assertions.assertTrue((boolean)processedNode.isValueNode());
        MatcherAssert.assertThat((Object)processedNode.asInt(), (Matcher)Matchers.equalTo((Object)32));
    }
}

