/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jsonpath;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import org.kie.kogito.jsonpath.JsonPathUtils;
import org.kie.kogito.process.workitems.impl.ExpressionWorkItemResolver;

public class JsonNodeJsonPathResolver
extends ExpressionWorkItemResolver {
    public JsonNodeJsonPathResolver(String jsonPathExpr, String paramName) {
        super(jsonPathExpr, paramName);
    }

    private JsonNode parse(Object input) {
        if (input instanceof JsonNode) {
            return (JsonNode)input;
        }
        ObjectMapper objectMapper = JsonPathUtils.getObjectMapper();
        if (input instanceof String) {
            if (JsonPathUtils.isJsonPath((String)input)) {
                return TextNode.valueOf((String)((String)input));
            }
            try {
                return objectMapper.readTree((String)input);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to parse input model from ordinary String to Json tree", e);
            }
        }
        return objectMapper.valueToTree(input);
    }

    protected Object evalExpression(Object inputModel) {
        return this.processInputModel(inputModel, this.parse(this.expression));
    }

    private JsonNode processInputModel(Object inputModel, JsonNode expression) {
        if (expression.isArray()) {
            JsonNode processedDefinition = expression.deepCopy();
            for (int index = 0; index < processedDefinition.size(); ++index) {
                ((ArrayNode)processedDefinition).set(index, this.processInputModel(inputModel, processedDefinition.get(index)));
            }
            return processedDefinition;
        }
        if (expression.isValueNode()) {
            String jsonPathExpr = expression.asText();
            if (JsonPathUtils.isJsonPath(jsonPathExpr)) {
                return JsonPathUtils.evalExpr(inputModel, jsonPathExpr);
            }
            return expression.deepCopy();
        }
        JsonNode processedDefinition = expression.deepCopy();
        Iterator fields = processedDefinition.fields();
        while (fields.hasNext()) {
            Map.Entry jsonField = (Map.Entry)fields.next();
            ((ObjectNode)processedDefinition).replace((String)jsonField.getKey(), this.processInputModel(inputModel, (JsonNode)jsonField.getValue()));
        }
        return processedDefinition;
    }
}

