/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app;

import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.kie.kogito.Config;
import org.kie.kogito.app.Processes;
import org.kie.kogito.app.RuleUnits;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Application
implements org.kie.kogito.Application {
    @Autowired(required=false)
    List<EventPublisher> eventPublishers;
    @Value(value="${kogito.service.url:#{null}}")
    Optional<String> kogitoService;
    @Autowired
    Config config;
    Processes processes = new Processes(this);
    RuleUnits ruleUnits = new RuleUnits(this);

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.config().process() != null) {
            if (this.eventPublishers != null) {
                this.eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            this.unitOfWorkManager().eventManager().setService(this.kogitoService.orElse(""));
            this.unitOfWorkManager().eventManager().setAddons(this.config().addons());
        }
    }

    public Processes processes() {
        return this.processes;
    }

    public RuleUnits ruleUnits() {
        return this.ruleUnits;
    }
}

