/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.acme.travel.Traveller;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.test.TravelersMessageDataEvent_3;
import org.kie.kogito.test.TravelersModel;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class TravelersMessageConsumer_3 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MessageConsumer");
    @Autowired
    @Qualifier(value="Travelers")
    Process<TravelersModel> process;
    @Autowired
    Application application;
    @Value(value="${kogito.messaging.as-cloudevents:#{null}}")
    Optional<Boolean> useCloudEvents = Optional.of(true);
    private ObjectMapper json = new ObjectMapper();

    public TravelersMessageConsumer_3() {
        this.json.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
    }

    @PostConstruct
    public void configure() {
    }

    @KafkaListener(topics={"travellers"})
    public void consume(String payload) {
        String trigger = "travellers";
        try {
            if (this.useCloudEvents.orElse(true).booleanValue()) {
                TravelersMessageDataEvent_3 eventData = (TravelersMessageDataEvent_3)this.json.readValue(payload, TravelersMessageDataEvent_3.class);
                TravelersModel model = new TravelersModel();
                model.setTraveller((Traveller)eventData.getData());
                UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                    if (eventData.getKogitoReferenceId() != null) {
                        LOGGER.debug("Received message with reference id '{}' going to use it to send signal '{}'", (Object)eventData.getKogitoReferenceId(), (Object)"travellers");
                        this.process.instances().findById(eventData.getKogitoReferenceId()).ifPresent(pi -> pi.send(Sig.of((String)"Message-travellers", (Object)((Traveller)eventData.getData()), (String)eventData.getKogitoProcessinstanceId())));
                    } else {
                        LOGGER.debug("Received message without reference id, staring new process instance with trigger '{}'", (Object)"travellers");
                        ProcessInstance pi2 = this.process.createInstance((Object)model);
                        if (eventData.getKogitoStartFromNode() != null) {
                            pi2.startFrom(eventData.getKogitoStartFromNode(), eventData.getKogitoProcessinstanceId());
                        } else {
                            pi2.start("travellers", eventData.getKogitoProcessinstanceId());
                        }
                    }
                    return null;
                });
            } else {
                Traveller eventData = (Traveller)this.json.readValue(payload, Traveller.class);
                TravelersModel model = new TravelersModel();
                model.setTraveller(eventData);
                UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                    LOGGER.debug("Received message without reference id, staring new process instance with trigger '{}'", (Object)"travellers");
                    ProcessInstance pi = this.process.createInstance((Object)model);
                    pi.start("travellers", null);
                    return null;
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Error when consuming message for process {}", (Object)this.process.id(), (Object)e);
        }
    }
}

