/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.regex.Pattern;

public final class JsonNodeParser {
    private static final String JSONPATH_REGEX = "^((\\$\\[).*|(\\$\\.).*)";
    private final ObjectMapper objectMapper;
    private final Pattern jsonPathRegexPattern;

    protected JsonNodeParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.jsonPathRegexPattern = Pattern.compile(JSONPATH_REGEX, 2);
    }

    protected JsonNode parse(Object input) {
        if (input instanceof JsonNode) {
            return (JsonNode)input;
        }
        if (input instanceof String) {
            if (this.isJsonPath((String)input)) {
                return TextNode.valueOf((String)((String)input));
            }
            try {
                return this.objectMapper.readTree((String)input);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to parse input model from ordinary String to Json tree", e);
            }
        }
        return this.objectMapper.valueToTree(input);
    }

    boolean isJsonPath(String expression) {
        return this.jsonPathRegexPattern.matcher(expression).matches();
    }
}

