/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kogito.workitem.openapi.JsonNodeResultHandler;

class JsonNodeResultHandlerTest {
    final ObjectMapper mapper = new ObjectMapper();

    JsonNodeResultHandlerTest() {
    }

    @Test
    void verifyInputModelAsArray() throws JsonProcessingException {
        JsonNodeResultHandler resultHandler = new JsonNodeResultHandler();
        String inputModel = "[{\"myKey\": \"myValue\"}]";
        JsonNode response = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        Object mergedResult = resultHandler.apply((Object)"[{\"myKey\": \"myValue\"}]", response);
        Assertions.assertNotNull((Object)mergedResult);
        Assertions.assertTrue((boolean)(mergedResult instanceof ArrayNode));
        Assertions.assertEquals((int)2, (int)((ArrayNode)mergedResult).size());
    }

    @Test
    void verifyResponseAsArray() throws JsonProcessingException {
        JsonNodeResultHandler resultHandler = new JsonNodeResultHandler();
        String inputModel = "{ \"workflowdata\": { \"name\": \"Brazil\" } }";
        JsonNode response = this.mapper.readTree("[{\"name\":\"Brazil\",\"topLevelDomain\":[\".br\"],\"alpha2Code\":\"BR\",\"alpha3Code\":\"BRA\",\"callingCodes\":[\"55\"],\"capital\":\"Bras\u00edlia\",\"altSpellings\":[\"BR\",\"Brasil\",\"Federative Republic of Brazil\",\"Rep\u00fablica Federativa do Brasil\"],\"region\":\"Americas\",\"subregion\":\"South America\",\"population\":206135893,\"latlng\":[-10.0,-55.0],\"demonym\":\"Brazilian\",\"area\":8515767.0,\"gini\":54.7,\"timezones\":[\"UTC-05:00\",\"UTC-04:00\",\"UTC-03:00\",\"UTC-02:00\"],\"borders\":[\"ARG\",\"BOL\",\"COL\",\"GUF\",\"GUY\",\"PRY\",\"PER\",\"SUR\",\"URY\",\"VEN\"],\"nativeName\":\"Brasil\",\"numericCode\":\"076\",\"currencies\":[{\"code\":\"BRL\",\"name\":\"Brazilian real\",\"symbol\":\"R$\"}],\"languages\":[{\"iso639_1\":\"pt\",\"iso639_2\":\"por\",\"name\":\"Portuguese\",\"nativeName\":\"Portugu\u00eas\"}],\"translations\":{\"de\":\"Brasilien\",\"es\":\"Brasil\",\"fr\":\"Br\u00e9sil\",\"ja\":\"\u30d6\u30e9\u30b8\u30eb\",\"it\":\"Brasile\",\"br\":\"Brasil\",\"pt\":\"Brasil\",\"nl\":\"Brazili\u00eb\",\"hr\":\"Brazil\",\"fa\":\"\u0628\u0631\u0632\u06cc\u0644\"},\"flag\":\"https://restcountries.eu/data/bra.svg\",\"regionalBlocs\":[{\"acronym\":\"USAN\",\"name\":\"Union of South American Nations\",\"otherAcronyms\":[\"UNASUR\",\"UNASUL\",\"UZAN\"],\"otherNames\":[\"Uni\u00f3n de Naciones Suramericanas\",\"Uni\u00e3o de Na\u00e7\u00f5es Sul-Americanas\",\"Unie van Zuid-Amerikaanse Naties\",\"South American Union\"]}],\"cioc\":\"BRA\"}]\n");
        Object mergedResult = resultHandler.apply((Object)"{ \"workflowdata\": { \"name\": \"Brazil\" } }", response);
        Assertions.assertNotNull((Object)mergedResult);
        Assertions.assertTrue((boolean)(mergedResult instanceof ObjectNode));
        Assertions.assertTrue((boolean)((ObjectNode)mergedResult).get("response").isArray());
    }
}

