/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi.factories;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.CommonTestUtility;
import org.kie.kogito.pmml.openapi.PMMLOASUtils;
import org.kie.kogito.pmml.openapi.api.PMMLOASResult;
import org.kie.kogito.pmml.openapi.factories.PMMLOASResultFactory;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.KiePMMLModel;

class PMMLOASResultFactoryTest {
    PMMLOASResultFactoryTest() {
    }

    @Test
    void getPMMLOASResultNoMiningFieldsNoOutputFields() {
        List<MiningField> miningFields = Collections.emptyList();
        List outputFields = Collections.emptyList();
        KiePMMLModel kiePMMLModel = CommonTestUtility.getKiePMMLModelInternal(miningFields, outputFields);
        PMMLOASResult retrieved = PMMLOASResultFactory.getPMMLOASResult((KiePMMLModel)kiePMMLModel);
        Assertions.assertNotNull((Object)retrieved);
        ObjectNode jsonNodes = retrieved.jsonSchemaNode();
        Assertions.assertNotNull((Object)jsonNodes);
        Assertions.assertFalse((boolean)jsonNodes.isEmpty());
        Assertions.assertNotNull((Object)jsonNodes.get("definitions"));
        JsonNode definitionsNode = jsonNodes.get("definitions");
        Assertions.assertFalse((boolean)definitionsNode.isEmpty());
        this.commonValidateInputSet(definitionsNode.get("InputSet"), miningFields);
        Assertions.assertNull((Object)definitionsNode.get("ResultSet"));
        Assertions.assertNotNull((Object)definitionsNode.get("OutputSet"));
        Assertions.assertNull((Object)definitionsNode.get("OutputSet").get("resultVariables"));
    }

    @Test
    void getPMMLOASResultMiningFieldsNoOutputFields() {
        List miningFields = CommonTestUtility.getRandomMiningFields();
        List<MiningField> predictedFields = miningFields.stream().filter(PMMLOASUtils::isPredicted).collect(Collectors.toList());
        List outputFields = Collections.emptyList();
        KiePMMLModel kiePMMLModel = CommonTestUtility.getKiePMMLModelInternal((List)miningFields, outputFields);
        PMMLOASResult retrieved = PMMLOASResultFactory.getPMMLOASResult((KiePMMLModel)kiePMMLModel);
        Assertions.assertNotNull((Object)retrieved);
        ObjectNode jsonNodes = retrieved.jsonSchemaNode();
        Assertions.assertNotNull((Object)jsonNodes);
        Assertions.assertFalse((boolean)jsonNodes.isEmpty());
        Assertions.assertNotNull((Object)jsonNodes.get("definitions"));
        JsonNode definitionsNode = jsonNodes.get("definitions");
        Assertions.assertFalse((boolean)definitionsNode.isEmpty());
        this.commonValidateInputSet(definitionsNode.get("InputSet"), miningFields);
        this.commonValidateResultSet(definitionsNode.get("ResultSet"), predictedFields);
        Assertions.assertNotNull((Object)definitionsNode.get("OutputSet"));
        Assertions.assertNotNull((Object)definitionsNode.get("OutputSet").get("properties"));
        Assertions.assertNotNull((Object)definitionsNode.get("OutputSet").get("properties").get("resultVariables"));
    }

    @Test
    void getPMMLOASResultMiningFieldsOutputFields() {
        List miningFields = CommonTestUtility.getRandomMiningFields();
        List<MiningField> predictedFields = miningFields.stream().filter(PMMLOASUtils::isPredicted).collect(Collectors.toList());
        List outputFields = CommonTestUtility.getRandomOutputFields();
        outputFields.add(CommonTestUtility.getRandomOutputField((String)((MiningField)miningFields.get(miningFields.size() - 1)).getName()));
        KiePMMLModel kiePMMLModel = CommonTestUtility.getKiePMMLModelInternal((List)miningFields, (List)outputFields);
        PMMLOASResult retrieved = PMMLOASResultFactory.getPMMLOASResult((KiePMMLModel)kiePMMLModel);
        Assertions.assertNotNull((Object)retrieved);
        ObjectNode jsonNodes = retrieved.jsonSchemaNode();
        Assertions.assertNotNull((Object)jsonNodes);
        Assertions.assertFalse((boolean)jsonNodes.isEmpty());
        Assertions.assertNotNull((Object)jsonNodes.get("definitions"));
        JsonNode definitionsNode = jsonNodes.get("definitions");
        Assertions.assertFalse((boolean)definitionsNode.isEmpty());
        this.commonValidateInputSet(definitionsNode.get("InputSet"), miningFields);
        this.commonValidateResultSet(definitionsNode.get("ResultSet"), predictedFields);
        Assertions.assertNotNull((Object)definitionsNode.get("OutputSet"));
        Assertions.assertNotNull((Object)definitionsNode.get("OutputSet").get("properties"));
        Assertions.assertNotNull((Object)definitionsNode.get("OutputSet").get("properties").get("resultVariables"));
        this.commonValidateOutputSet(definitionsNode.get("OutputSet").get("properties").get("resultVariables"), outputFields);
    }

    private void commonValidateInputSet(JsonNode toValidate, List<MiningField> miningFields) {
        Assertions.assertNotNull((Object)toValidate);
        Assertions.assertEquals((Object)"object", (Object)toValidate.get("type").asText());
        Assertions.assertNotNull((Object)toValidate.get("required"));
        Assertions.assertNotNull((Object)toValidate.get("properties"));
        ArrayNode requiredNode = (ArrayNode)toValidate.get("required");
        List requiredMiningFields = miningFields.stream().filter(PMMLOASUtils::isRequired).collect(Collectors.toList());
        Assertions.assertEquals((int)requiredMiningFields.size(), (int)requiredNode.size());
        List requiredJsonNodes = CommonTestUtility.getFromArrayNode((ArrayNode)requiredNode);
        ObjectNode propertiesNode = (ObjectNode)toValidate.get("properties");
        List active = miningFields.stream().filter(miningField -> !PMMLOASUtils.isPredicted((MiningField)miningField)).collect(Collectors.toList());
        Assertions.assertEquals((int)active.size(), (int)propertiesNode.size());
        for (MiningField miningField2 : requiredMiningFields) {
            JsonNode required = CommonTestUtility.getFromJsonNodeList((List)requiredJsonNodes, (String)miningField2.getName());
            Assertions.assertNotNull((Object)required);
        }
        for (MiningField miningField2 : active) {
            JsonNode property = propertiesNode.get(miningField2.getName());
            Assertions.assertNotNull((Object)property);
            ObjectNode typeFieldNode = (ObjectNode)property;
            Assertions.assertNotNull((Object)typeFieldNode.get("type"));
            TextNode typeNode = (TextNode)typeFieldNode.get("type");
            String mappedType = PMMLOASUtils.getMappedType((DATA_TYPE)miningField2.getDataType());
            Assertions.assertEquals((Object)mappedType, (Object)typeNode.asText());
        }
    }

    private void commonValidateResultSet(JsonNode toValidate, List<MiningField> miningFields) {
        Assertions.assertNotNull((Object)toValidate);
        Assertions.assertEquals((Object)"object", (Object)toValidate.get("type").asText());
        Assertions.assertNotNull((Object)toValidate.get("properties"));
        ObjectNode propertiesNode = (ObjectNode)toValidate.get("properties");
        for (MiningField miningField : miningFields) {
            JsonNode property = propertiesNode.get(miningField.getName());
            Assertions.assertNotNull((Object)property);
            ObjectNode typeFieldNode = (ObjectNode)property;
            Assertions.assertNotNull((Object)typeFieldNode.get("type"));
            TextNode typeNode = (TextNode)typeFieldNode.get("type");
            String mappedType = PMMLOASUtils.getMappedType((DATA_TYPE)miningField.getDataType());
            Assertions.assertEquals((Object)mappedType, (Object)typeNode.asText());
        }
    }

    private void commonValidateOutputSet(JsonNode toValidate, List<OutputField> outputFields) {
        Assertions.assertNotNull((Object)toValidate);
        Assertions.assertEquals((Object)"object", (Object)toValidate.get("type").asText());
        Assertions.assertNotNull((Object)toValidate.get("properties"));
        ObjectNode propertiesNode = (ObjectNode)toValidate.get("properties");
        for (OutputField outputField : outputFields) {
            JsonNode property = propertiesNode.get(outputField.getName());
            Assertions.assertNotNull((Object)property);
            ObjectNode typeFieldNode = (ObjectNode)property;
            Assertions.assertNotNull((Object)typeFieldNode.get("type"));
            TextNode typeNode = (TextNode)typeFieldNode.get("type");
            String mappedType = PMMLOASUtils.getMappedType((DATA_TYPE)outputField.getDataType());
            Assertions.assertEquals((Object)mappedType, (Object)typeNode.asText());
        }
    }
}

