/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.CommonTestUtility;
import org.kie.kogito.pmml.openapi.impl.PMMLOASResultImpl;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.ResultCode;

class PMMLOASResultImplTest {
    PMMLOASResultImplTest() {
    }

    @Test
    void constructor() {
        PMMLOASResultImpl retrieved = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        Assertions.assertNotNull((Object)retrieved);
        ObjectNode jsonNodes = retrieved.jsonNodes;
        Assertions.assertNotNull((Object)jsonNodes);
        ObjectNode definitions = (ObjectNode)jsonNodes.get("definitions");
        Assertions.assertNotNull((Object)definitions);
        ObjectNode outputSet = (ObjectNode)definitions.get("OutputSet");
        Assertions.assertNotNull((Object)outputSet);
        this.commonValidateOutputSet(outputSet);
    }

    @Test
    void addMiningFields() {
        PMMLOASResultImpl retrieved = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        List miningFields = CommonTestUtility.getRandomMiningFields();
        retrieved.addMiningFields(miningFields);
        ObjectNode jsonNodes = retrieved.jsonNodes;
        Assertions.assertNotNull((Object)jsonNodes);
        ObjectNode definitions = (ObjectNode)jsonNodes.get("definitions");
        Assertions.assertNotNull((Object)definitions);
        ObjectNode inputSet = (ObjectNode)definitions.get("InputSet");
        Assertions.assertNotNull((Object)inputSet);
    }

    @Test
    void addOutputFields() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        ObjectNode outputSetNode = (ObjectNode)definitionsNode.get("OutputSet");
        ObjectNode outputSetPropertiesNode = (ObjectNode)outputSetNode.get("properties");
        Assertions.assertNull((Object)outputSetPropertiesNode.get("resultVariables"));
        List toAdd = CommonTestUtility.getRandomOutputFields();
        pmmlOAResult.addOutputFields(toAdd);
        Assertions.assertNotNull((Object)outputSetPropertiesNode.get("resultVariables"));
        ObjectNode resultVariablesNode = (ObjectNode)outputSetPropertiesNode.get("resultVariables");
        Assertions.assertNotNull((Object)resultVariablesNode.get("properties"));
        ObjectNode resultVariablesPropertiesNode = (ObjectNode)resultVariablesNode.get("properties");
        Assertions.assertEquals((int)toAdd.size(), (int)resultVariablesPropertiesNode.size());
        List<JsonNode> nodeList = StreamSupport.stream(resultVariablesPropertiesNode.spliterator(), false).collect(Collectors.toList());
        nodeList.forEach(resultNode -> Assertions.assertTrue((boolean)(resultNode instanceof ObjectNode)));
        toAdd.forEach(outputField -> Assertions.assertNotNull((Object)resultVariablesPropertiesNode.get(outputField.getName())));
    }

    @Test
    void addToResultSet() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        definitionsNode.removeAll();
        Assertions.assertNull((Object)definitionsNode.get("ResultSet"));
        String fieldName = "fieldName";
        DATA_TYPE dataType = DATA_TYPE.DOUBLE;
        pmmlOAResult.addToResultSet(fieldName, dataType, Collections.emptyList());
        Assertions.assertNotNull((Object)definitionsNode.get("ResultSet"));
        ObjectNode resultSetNode = (ObjectNode)definitionsNode.get("ResultSet");
        ObjectNode resultSetPropertiesNode = (ObjectNode)resultSetNode.get("properties");
        Assertions.assertNotNull((Object)resultSetPropertiesNode);
        Assertions.assertNotNull((Object)resultSetPropertiesNode.get(fieldName));
    }

    @Test
    void addToResultVariables() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        ObjectNode outputSetNode = (ObjectNode)definitionsNode.get("OutputSet");
        ObjectNode propertiesNode = (ObjectNode)outputSetNode.get("properties");
        Assertions.assertNull((Object)propertiesNode.get("resultVariables"));
        String fieldName = "fieldName";
        DATA_TYPE dataType = DATA_TYPE.DOUBLE;
        pmmlOAResult.addToResultVariables(fieldName, dataType, Collections.emptyList());
        Assertions.assertNotNull((Object)propertiesNode.get("resultVariables"));
        ObjectNode resultVariablesNode = (ObjectNode)propertiesNode.get("resultVariables");
        ObjectNode resultVariablesPropertiesNode = (ObjectNode)resultVariablesNode.get("properties");
        Assertions.assertNotNull((Object)resultVariablesPropertiesNode);
        Assertions.assertNotNull((Object)resultVariablesPropertiesNode.get(fieldName));
    }

    @Test
    void conditionallyCreateResultSetNode() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        definitionsNode.removeAll();
        Assertions.assertNull((Object)definitionsNode.get("ResultSet"));
        ObjectNode created = pmmlOAResult.conditionallyCreateResultSetNode();
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)created, (Object)definitionsNode.get("ResultSet"));
        ObjectNode notCreated = pmmlOAResult.conditionallyCreateResultSetNode();
        Assertions.assertEquals((Object)created, (Object)notCreated);
    }

    @Test
    void conditionallyCreateResultVariablesNode() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        ObjectNode outputSetNode = (ObjectNode)definitionsNode.get("OutputSet");
        ObjectNode propertiesNode = (ObjectNode)outputSetNode.get("properties");
        propertiesNode.removeAll();
        Assertions.assertNull((Object)propertiesNode.get("resultVariables"));
        ObjectNode created = pmmlOAResult.conditionallyCreateResultVariablesNode();
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)created, (Object)propertiesNode.get("resultVariables"));
        ObjectNode notCreated = pmmlOAResult.conditionallyCreateResultVariablesNode();
        Assertions.assertEquals((Object)created, (Object)notCreated);
    }

    @Test
    void conditionallyCreateSetNode() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        String nodeToCreate = "nodeToCreate";
        Assertions.assertNull((Object)definitionsNode.get(nodeToCreate));
        ObjectNode created = pmmlOAResult.conditionallyCreateSetNode(nodeToCreate);
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)created, (Object)definitionsNode.get(nodeToCreate));
        ObjectNode notCreated = pmmlOAResult.conditionallyCreateSetNode(nodeToCreate);
        Assertions.assertEquals((Object)created, (Object)notCreated);
    }

    private void commonValidateOutputSet(ObjectNode toValidate) {
        JsonNode typeNode = toValidate.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"object", (Object)((TextNode)typeNode).asText());
        JsonNode propertiesNode = toValidate.get("properties");
        Assertions.assertNotNull((Object)propertiesNode);
        Assertions.assertTrue((boolean)(propertiesNode instanceof ObjectNode));
        JsonNode correlationIdNode = propertiesNode.get("correlationId");
        Assertions.assertNotNull((Object)correlationIdNode);
        Assertions.assertTrue((boolean)(correlationIdNode instanceof ObjectNode));
        typeNode = correlationIdNode.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"string", (Object)((TextNode)typeNode).asText());
        JsonNode segmentationIdNode = propertiesNode.get("segmentationId");
        Assertions.assertNotNull((Object)segmentationIdNode);
        Assertions.assertTrue((boolean)(segmentationIdNode instanceof ObjectNode));
        typeNode = segmentationIdNode.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"string", (Object)((TextNode)typeNode).asText());
        JsonNode segmentIdNode = propertiesNode.get("segmentId");
        Assertions.assertNotNull((Object)segmentIdNode);
        Assertions.assertTrue((boolean)(segmentIdNode instanceof ObjectNode));
        typeNode = segmentIdNode.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"string", (Object)((TextNode)typeNode).asText());
        JsonNode segmentIndexNode = propertiesNode.get("segmentIndex");
        Assertions.assertNotNull((Object)segmentIndexNode);
        Assertions.assertTrue((boolean)(segmentIndexNode instanceof ObjectNode));
        typeNode = segmentIndexNode.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"integer", (Object)((TextNode)typeNode).asText());
        JsonNode resultCodeNode = propertiesNode.get("resultCode");
        Assertions.assertNotNull((Object)resultCodeNode);
        Assertions.assertTrue((boolean)(resultCodeNode instanceof ObjectNode));
        typeNode = resultCodeNode.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"string", (Object)((TextNode)typeNode).asText());
        JsonNode enumNode = resultCodeNode.get("enum");
        Assertions.assertNotNull((Object)enumNode);
        Assertions.assertTrue((boolean)(enumNode instanceof ArrayNode));
        Assertions.assertEquals((int)ResultCode.values().length, (int)((ArrayNode)enumNode).size());
        Iterator enumElements = enumNode.elements();
        Arrays.stream(ResultCode.values()).forEach(resultCode -> {
            boolean find = false;
            while (enumElements.hasNext()) {
                JsonNode node = (JsonNode)enumElements.next();
                Assertions.assertTrue((boolean)(node instanceof TextNode));
                if (!resultCode.getName().equals(((TextNode)node).asText())) continue;
                find = true;
                break;
            }
            Assertions.assertTrue((boolean)find);
        });
        JsonNode resultObjectNameNode = propertiesNode.get("resultObjectName");
        Assertions.assertNotNull((Object)resultObjectNameNode);
        Assertions.assertTrue((boolean)(resultObjectNameNode instanceof ObjectNode));
        typeNode = resultObjectNameNode.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"string", (Object)((TextNode)typeNode).asText());
    }
}

