/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.CommonTestUtility;
import org.kie.kogito.pmml.openapi.impl.PMMLOASResultImpl;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.ResultCode;

class PMMLOASResultImplTest {
    PMMLOASResultImplTest() {
    }

    @Test
    void constructor() {
        PMMLOASResultImpl retrieved = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        Assertions.assertThat((Object)retrieved).isNotNull();
        ObjectNode jsonNodes = retrieved.jsonNodes;
        Assertions.assertThat((Iterable)jsonNodes).isNotNull();
        ObjectNode definitions = (ObjectNode)jsonNodes.get("definitions");
        Assertions.assertThat((Iterable)definitions).isNotNull();
        ObjectNode outputSet = (ObjectNode)definitions.get("OutputSet");
        Assertions.assertThat((Iterable)outputSet).isNotNull();
        this.commonValidateOutputSet(outputSet);
    }

    @Test
    void addMiningFields() {
        PMMLOASResultImpl retrieved = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        List miningFields = CommonTestUtility.getRandomMiningFields();
        retrieved.addMiningFields(miningFields);
        ObjectNode jsonNodes = retrieved.jsonNodes;
        Assertions.assertThat((Iterable)jsonNodes).isNotNull();
        ObjectNode definitions = (ObjectNode)jsonNodes.get("definitions");
        Assertions.assertThat((Iterable)definitions).isNotNull();
        ObjectNode inputSet = (ObjectNode)definitions.get("InputSet");
        Assertions.assertThat((Iterable)inputSet).isNotNull();
    }

    @Test
    void addOutputFields() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        ObjectNode outputSetNode = (ObjectNode)definitionsNode.get("OutputSet");
        ObjectNode outputSetPropertiesNode = (ObjectNode)outputSetNode.get("properties");
        Assertions.assertThat((Iterable)outputSetPropertiesNode.get("resultVariables")).isNull();
        List toAdd = CommonTestUtility.getRandomOutputFields();
        pmmlOAResult.addOutputFields(toAdd);
        Assertions.assertThat((Iterable)outputSetPropertiesNode.get("resultVariables")).isNotNull();
        ObjectNode resultVariablesNode = (ObjectNode)outputSetPropertiesNode.get("resultVariables");
        Assertions.assertThat((Iterable)resultVariablesNode.get("properties")).isNotNull();
        ObjectNode resultVariablesPropertiesNode = (ObjectNode)resultVariablesNode.get("properties");
        Assertions.assertThat((Iterable)resultVariablesPropertiesNode).hasSameSizeAs((Iterable)toAdd);
        List nodeList = StreamSupport.stream(resultVariablesPropertiesNode.spliterator(), false).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(nodeList).isNotEmpty()).allMatch(resultNode -> resultNode instanceof ObjectNode);
        Assertions.assertThat((List)toAdd).allSatisfy(outputField -> Assertions.assertThat((Iterable)resultVariablesPropertiesNode.get(outputField.getName())).isNotNull());
    }

    @Test
    void addToResultSet() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        definitionsNode.removeAll();
        Assertions.assertThat((Iterable)definitionsNode.get("ResultSet")).isNull();
        String fieldName = "fieldName";
        DATA_TYPE dataType = DATA_TYPE.DOUBLE;
        pmmlOAResult.addToResultSet(fieldName, dataType, Collections.emptyList());
        Assertions.assertThat((Iterable)definitionsNode.get("ResultSet")).isNotNull();
        ObjectNode resultSetNode = (ObjectNode)definitionsNode.get("ResultSet");
        ObjectNode resultSetPropertiesNode = (ObjectNode)resultSetNode.get("properties");
        Assertions.assertThat((Iterable)resultSetPropertiesNode).isNotNull();
        Assertions.assertThat((Iterable)resultSetPropertiesNode.get(fieldName)).isNotNull();
    }

    @Test
    void addToResultVariables() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        ObjectNode outputSetNode = (ObjectNode)definitionsNode.get("OutputSet");
        ObjectNode propertiesNode = (ObjectNode)outputSetNode.get("properties");
        Assertions.assertThat((Iterable)propertiesNode.get("resultVariables")).isNull();
        String fieldName = "fieldName";
        DATA_TYPE dataType = DATA_TYPE.DOUBLE;
        pmmlOAResult.addToResultVariables(fieldName, dataType, Collections.emptyList());
        Assertions.assertThat((Iterable)propertiesNode.get("resultVariables")).isNotNull();
        ObjectNode resultVariablesNode = (ObjectNode)propertiesNode.get("resultVariables");
        ObjectNode resultVariablesPropertiesNode = (ObjectNode)resultVariablesNode.get("properties");
        Assertions.assertThat((Iterable)resultVariablesPropertiesNode).isNotNull();
        Assertions.assertThat((Iterable)resultVariablesPropertiesNode.get(fieldName)).isNotNull();
    }

    @Test
    void conditionallyCreateResultSetNode() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        definitionsNode.removeAll();
        Assertions.assertThat((Iterable)definitionsNode.get("ResultSet")).isNull();
        ObjectNode created = pmmlOAResult.conditionallyCreateResultSetNode();
        Assertions.assertThat((Iterable)created).isNotNull();
        Assertions.assertThat((Iterable)definitionsNode.get("ResultSet")).isEqualTo((Object)created);
        ObjectNode notCreated = pmmlOAResult.conditionallyCreateResultSetNode();
        Assertions.assertThat((Iterable)notCreated).isEqualTo((Object)created);
    }

    @Test
    void conditionallyCreateResultVariablesNode() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        ObjectNode outputSetNode = (ObjectNode)definitionsNode.get("OutputSet");
        ObjectNode propertiesNode = (ObjectNode)outputSetNode.get("properties");
        propertiesNode.removeAll();
        Assertions.assertThat((Iterable)propertiesNode.get("resultVariables")).isNull();
        ObjectNode created = pmmlOAResult.conditionallyCreateResultVariablesNode();
        Assertions.assertThat((Iterable)created).isNotNull();
        Assertions.assertThat((Iterable)propertiesNode.get("resultVariables")).isEqualTo((Object)created);
        ObjectNode notCreated = pmmlOAResult.conditionallyCreateResultVariablesNode();
        Assertions.assertThat((Iterable)notCreated).isEqualTo((Object)created);
    }

    @Test
    void conditionallyCreateSetNode() {
        PMMLOASResultImpl pmmlOAResult = (PMMLOASResultImpl)new PMMLOASResultImpl.Builder().build();
        ObjectNode jsonNodes = pmmlOAResult.jsonNodes;
        ObjectNode definitionsNode = (ObjectNode)jsonNodes.get("definitions");
        String nodeToCreate = "nodeToCreate";
        Assertions.assertThat((Iterable)definitionsNode.get(nodeToCreate)).isNull();
        ObjectNode created = pmmlOAResult.conditionallyCreateSetNode(nodeToCreate);
        Assertions.assertThat((Iterable)created).isNotNull();
        Assertions.assertThat((Iterable)definitionsNode.get(nodeToCreate)).isEqualTo((Object)created);
        ObjectNode notCreated = pmmlOAResult.conditionallyCreateSetNode(nodeToCreate);
        Assertions.assertThat((Iterable)notCreated).isEqualTo((Object)created);
    }

    private void commonValidateOutputSet(ObjectNode toValidate) {
        JsonNode typeNode = toValidate.get("type");
        Assertions.assertThat((Iterable)typeNode).isNotNull();
        Assertions.assertThat((Iterable)typeNode).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("object");
        JsonNode propertiesNode = toValidate.get("properties");
        Assertions.assertThat((Iterable)propertiesNode).isNotNull();
        Assertions.assertThat((Iterable)propertiesNode).isInstanceOf(ObjectNode.class);
        JsonNode correlationIdNode = propertiesNode.get("correlationId");
        Assertions.assertThat((Iterable)correlationIdNode).isNotNull();
        Assertions.assertThat((Iterable)correlationIdNode).isInstanceOf(ObjectNode.class);
        typeNode = correlationIdNode.get("type");
        Assertions.assertThat((Iterable)typeNode).isNotNull();
        Assertions.assertThat((Iterable)typeNode).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("string");
        JsonNode segmentationIdNode = propertiesNode.get("segmentationId");
        Assertions.assertThat((Iterable)segmentationIdNode).isNotNull();
        Assertions.assertThat((Iterable)segmentationIdNode).isInstanceOf(ObjectNode.class);
        typeNode = segmentationIdNode.get("type");
        Assertions.assertThat((Iterable)typeNode).isNotNull();
        Assertions.assertThat((Iterable)typeNode).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("string");
        JsonNode segmentIdNode = propertiesNode.get("segmentId");
        Assertions.assertThat((Iterable)segmentIdNode).isNotNull();
        Assertions.assertThat((Iterable)segmentIdNode).isInstanceOf(ObjectNode.class);
        typeNode = segmentIdNode.get("type");
        Assertions.assertThat((Iterable)typeNode).isNotNull();
        Assertions.assertThat((Iterable)typeNode).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("string");
        JsonNode segmentIndexNode = propertiesNode.get("segmentIndex");
        Assertions.assertThat((Iterable)segmentIndexNode).isNotNull();
        Assertions.assertThat((Iterable)segmentIndexNode).isInstanceOf(ObjectNode.class);
        typeNode = segmentIndexNode.get("type");
        Assertions.assertThat((Iterable)typeNode).isNotNull();
        Assertions.assertThat((Iterable)typeNode).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("integer");
        JsonNode resultCodeNode = propertiesNode.get("resultCode");
        Assertions.assertThat((Iterable)resultCodeNode).isNotNull();
        Assertions.assertThat((Iterable)resultCodeNode).isInstanceOf(ObjectNode.class);
        typeNode = resultCodeNode.get("type");
        Assertions.assertThat((Iterable)typeNode).isNotNull();
        Assertions.assertThat((Iterable)typeNode).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("string");
        JsonNode enumNode = resultCodeNode.get("enum");
        Assertions.assertThat((Iterable)enumNode).isNotNull();
        Assertions.assertThat((Iterable)enumNode).isInstanceOf(ArrayNode.class);
        Assertions.assertThat((Iterable)((ArrayNode)enumNode)).hasSameSizeAs((Object)ResultCode.values());
        List enumElements = StreamSupport.stream(enumNode.spliterator(), false).collect(Collectors.toList());
        Assertions.assertThat(enumElements).allMatch(node -> node instanceof TextNode);
        Assertions.assertThat((Object[])ResultCode.values()).extracting(resultCode -> resultCode.getName()).allSatisfy(name -> Assertions.assertThat((List)enumElements).extracting(enumElement -> enumElement.asText()).contains((Object[])new String[]{name}));
        JsonNode resultObjectNameNode = propertiesNode.get("resultObjectName");
        Assertions.assertThat((Iterable)resultObjectNameNode).isNotNull();
        Assertions.assertThat((Iterable)resultObjectNameNode).isInstanceOf(ObjectNode.class);
        typeNode = resultObjectNameNode.get("type");
        Assertions.assertThat((Iterable)typeNode).isNotNull();
        Assertions.assertThat((Iterable)typeNode).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("string");
    }
}

