/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi.factories;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.CommonTestUtility;
import org.kie.kogito.pmml.openapi.PMMLOASUtils;
import org.kie.kogito.pmml.openapi.api.PMMLOASResult;
import org.kie.kogito.pmml.openapi.factories.PMMLOASResultFactory;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.KiePMMLModel;

class PMMLOASResultFactoryTest {
    PMMLOASResultFactoryTest() {
    }

    @Test
    void getPMMLOASResultNoMiningFieldsNoOutputFields() {
        List<MiningField> miningFields = Collections.emptyList();
        List outputFields = Collections.emptyList();
        KiePMMLModel kiePMMLModel = CommonTestUtility.getKiePMMLModelInternal(miningFields, outputFields);
        PMMLOASResult retrieved = PMMLOASResultFactory.getPMMLOASResult((KiePMMLModel)kiePMMLModel);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ObjectNode jsonNodes = retrieved.jsonSchemaNode();
        ((IterableAssert)Assertions.assertThat((Iterable)jsonNodes).isNotNull()).isNotEmpty();
        Assertions.assertThat((Iterable)jsonNodes.get("definitions")).isNotNull();
        JsonNode definitionsNode = jsonNodes.get("definitions");
        Assertions.assertThat((Iterable)definitionsNode).isNotEmpty();
        this.commonValidateInputSet(definitionsNode.get("InputSet"), miningFields);
        Assertions.assertThat((Iterable)definitionsNode.get("ResultSet")).isNull();
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet")).isNotNull();
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet").get("resultVariables")).isNull();
    }

    @Test
    void getPMMLOASResultMiningFieldsNoOutputFields() {
        List miningFields = CommonTestUtility.getRandomMiningFields();
        List<MiningField> predictedFields = miningFields.stream().filter(PMMLOASUtils::isPredicted).collect(Collectors.toList());
        List outputFields = Collections.emptyList();
        KiePMMLModel kiePMMLModel = CommonTestUtility.getKiePMMLModelInternal((List)miningFields, outputFields);
        PMMLOASResult retrieved = PMMLOASResultFactory.getPMMLOASResult((KiePMMLModel)kiePMMLModel);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ObjectNode jsonNodes = retrieved.jsonSchemaNode();
        ((IterableAssert)Assertions.assertThat((Iterable)jsonNodes).isNotNull()).isNotEmpty();
        Assertions.assertThat((Iterable)jsonNodes.get("definitions")).isNotNull();
        JsonNode definitionsNode = jsonNodes.get("definitions");
        Assertions.assertThat((boolean)definitionsNode.isEmpty()).isFalse();
        this.commonValidateInputSet(definitionsNode.get("InputSet"), miningFields);
        this.commonValidateResultSet(definitionsNode.get("ResultSet"), predictedFields);
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet")).isNotNull();
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet").get("properties")).isNotNull();
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet").get("properties").get("resultVariables")).isNotNull();
    }

    @Test
    void getPMMLOASResultMiningFieldsOutputFields() {
        List miningFields = CommonTestUtility.getRandomMiningFields();
        List<MiningField> predictedFields = miningFields.stream().filter(PMMLOASUtils::isPredicted).collect(Collectors.toList());
        List outputFields = CommonTestUtility.getRandomOutputFields();
        outputFields.add(CommonTestUtility.getRandomOutputField((String)((MiningField)miningFields.get(miningFields.size() - 1)).getName()));
        KiePMMLModel kiePMMLModel = CommonTestUtility.getKiePMMLModelInternal((List)miningFields, (List)outputFields);
        PMMLOASResult retrieved = PMMLOASResultFactory.getPMMLOASResult((KiePMMLModel)kiePMMLModel);
        Assertions.assertThat((Object)retrieved).isNotNull();
        ObjectNode jsonNodes = retrieved.jsonSchemaNode();
        ((IterableAssert)Assertions.assertThat((Iterable)jsonNodes).isNotNull()).isNotEmpty();
        Assertions.assertThat((Iterable)jsonNodes.get("definitions")).isNotNull();
        JsonNode definitionsNode = jsonNodes.get("definitions");
        Assertions.assertThat((Iterable)definitionsNode).isNotEmpty();
        this.commonValidateInputSet(definitionsNode.get("InputSet"), miningFields);
        this.commonValidateResultSet(definitionsNode.get("ResultSet"), predictedFields);
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet")).isNotNull();
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet").get("properties")).isNotNull();
        Assertions.assertThat((Iterable)definitionsNode.get("OutputSet").get("properties").get("resultVariables")).isNotNull();
        this.commonValidateOutputSet(definitionsNode.get("OutputSet").get("properties").get("resultVariables"), outputFields);
    }

    private void commonValidateInputSet(JsonNode toValidate, List<MiningField> miningFields) {
        Assertions.assertThat((Iterable)toValidate).isNotNull();
        Assertions.assertThat((String)toValidate.get("type").asText()).isEqualTo("object");
        Assertions.assertThat((Iterable)toValidate.get("required")).isNotNull();
        Assertions.assertThat((Iterable)toValidate.get("properties")).isNotNull();
        ArrayNode requiredNode = (ArrayNode)toValidate.get("required");
        List requiredMiningFields = miningFields.stream().filter(PMMLOASUtils::isRequired).collect(Collectors.toList());
        Assertions.assertThat((Iterable)requiredNode).hasSameSizeAs(requiredMiningFields);
        List requiredJsonNodes = CommonTestUtility.getFromArrayNode((ArrayNode)requiredNode);
        ObjectNode propertiesNode = (ObjectNode)toValidate.get("properties");
        List active = miningFields.stream().filter(miningField -> !PMMLOASUtils.isPredicted((MiningField)miningField)).collect(Collectors.toList());
        Assertions.assertThat((Iterable)propertiesNode).hasSameSizeAs(active);
        Assertions.assertThat(requiredMiningFields).allMatch(miningField -> CommonTestUtility.getFromJsonNodeList((List)requiredJsonNodes, (String)miningField.getName()) != null);
        Assertions.assertThat(active).allSatisfy(miningField -> {
            JsonNode property = propertiesNode.get(miningField.getName());
            Assertions.assertThat((Iterable)property).isNotNull();
            ObjectNode typeFieldNode = (ObjectNode)property;
            Assertions.assertThat((Iterable)typeFieldNode.get("type")).isNotNull();
            TextNode typeNode = (TextNode)typeFieldNode.get("type");
            String mappedType = PMMLOASUtils.getMappedType((DATA_TYPE)miningField.getDataType());
            Assertions.assertThat((String)typeNode.asText()).isEqualTo(mappedType);
        });
    }

    private void commonValidateResultSet(JsonNode toValidate, List<MiningField> miningFields) {
        Assertions.assertThat((Iterable)toValidate).isNotNull();
        Assertions.assertThat((String)toValidate.get("type").asText()).isEqualTo("object");
        Assertions.assertThat((Iterable)toValidate.get("properties")).isNotNull();
        ObjectNode propertiesNode = (ObjectNode)toValidate.get("properties");
        ((ListAssert)Assertions.assertThat(miningFields).isNotEmpty()).allSatisfy(miningField -> {
            JsonNode property = propertiesNode.get(miningField.getName());
            Assertions.assertThat((Iterable)property).isNotNull();
            ObjectNode typeFieldNode = (ObjectNode)property;
            Assertions.assertThat((Iterable)typeFieldNode.get("type")).isNotNull();
            TextNode typeNode = (TextNode)typeFieldNode.get("type");
            String mappedType = PMMLOASUtils.getMappedType((DATA_TYPE)miningField.getDataType());
            Assertions.assertThat((String)typeNode.asText()).isEqualTo(mappedType);
        });
    }

    private void commonValidateOutputSet(JsonNode toValidate, List<OutputField> outputFields) {
        Assertions.assertThat((Iterable)toValidate).isNotNull();
        Assertions.assertThat((String)toValidate.get("type").asText()).isEqualTo("object");
        Assertions.assertThat((Iterable)toValidate.get("properties")).isNotNull();
        ObjectNode propertiesNode = (ObjectNode)toValidate.get("properties");
        ((ListAssert)Assertions.assertThat(outputFields).isNotEmpty()).allSatisfy(outputField -> {
            JsonNode property = propertiesNode.get(outputField.getName());
            Assertions.assertThat((Iterable)property).isNotNull();
            ObjectNode typeFieldNode = (ObjectNode)property;
            Assertions.assertThat((Iterable)typeFieldNode.get("type")).isNotNull();
            TextNode typeNode = (TextNode)typeFieldNode.get("type");
            String mappedType = PMMLOASUtils.getMappedType((DATA_TYPE)outputField.getDataType());
            Assertions.assertThat((String)typeNode.asText()).isEqualTo(mappedType);
        });
    }
}

