/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.openapi.PMMLOASUtils;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;

class PMMLOASUtilsTest {
    PMMLOASUtilsTest() {
    }

    @Test
    void isRequired() {
        MiningField toVerify = new MiningField(null, FIELD_USAGE_TYPE.PREDICTED, null, null, null, null, null);
        Assertions.assertFalse((boolean)PMMLOASUtils.isRequired((MiningField)toVerify));
        toVerify = new MiningField(null, FIELD_USAGE_TYPE.TARGET, null, null, null, null, null);
        Assertions.assertFalse((boolean)PMMLOASUtils.isRequired((MiningField)toVerify));
        toVerify = new MiningField(null, null, null, null, "MISSING_VALUE_REPLACEMENT", null, null);
        Assertions.assertFalse((boolean)PMMLOASUtils.isRequired((MiningField)toVerify));
        toVerify = new MiningField(null, null, null, null, null, null, null);
        Assertions.assertTrue((boolean)PMMLOASUtils.isRequired((MiningField)toVerify));
    }

    @Test
    void isPredicted() {
        MiningField toVerify = new MiningField(null, FIELD_USAGE_TYPE.PREDICTED, null, null, null, null, null);
        Assertions.assertTrue((boolean)PMMLOASUtils.isPredicted((MiningField)toVerify));
        toVerify = new MiningField(null, FIELD_USAGE_TYPE.TARGET, null, null, null, null, null);
        Assertions.assertTrue((boolean)PMMLOASUtils.isPredicted((MiningField)toVerify));
        toVerify = new MiningField(null, null, null, null, null, null, null);
        Assertions.assertFalse((boolean)PMMLOASUtils.isPredicted((MiningField)toVerify));
        Arrays.stream(FIELD_USAGE_TYPE.values()).filter(usageType -> usageType != FIELD_USAGE_TYPE.TARGET && usageType != FIELD_USAGE_TYPE.PREDICTED).forEach(usageType -> {
            MiningField miningField = new MiningField(null, usageType, null, null, null, null, null);
            Assertions.assertFalse((boolean)PMMLOASUtils.isPredicted((MiningField)miningField));
        });
    }

    @Test
    void getMappedType() {
        Arrays.stream(DATA_TYPE.values()).forEach(dataType -> {
            String expected;
            switch (dataType) {
                case DATE: 
                case DATE_TIME: 
                case STRING: {
                    expected = "string";
                    break;
                }
                case BOOLEAN: {
                    expected = "boolean";
                    break;
                }
                case INTEGER: {
                    expected = "integer";
                    break;
                }
                default: {
                    expected = "number";
                }
            }
            Assertions.assertEquals((Object)expected, (Object)PMMLOASUtils.getMappedType((DATA_TYPE)dataType));
        });
    }

    @Test
    void getMappedFormat() {
        Arrays.stream(DATA_TYPE.values()).forEach(dataType -> {
            String expected;
            switch (dataType) {
                case DOUBLE: {
                    expected = "double";
                    break;
                }
                case FLOAT: {
                    expected = "float";
                    break;
                }
                default: {
                    expected = null;
                }
            }
            Assertions.assertEquals((Object)expected, (Object)PMMLOASUtils.getMappedFormat((DATA_TYPE)dataType));
        });
    }

    @Test
    void addIntervals() {
        ObjectNode typeFieldNode = JsonUtil.objectNode();
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.emptyList());
        Assertions.assertEquals((int)0, (int)typeFieldNode.size());
        Interval interval = new Interval((Number)-34.23, null);
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.singletonList(interval));
        Assertions.assertNotNull((Object)typeFieldNode.get("minimum"));
        NumericNode numericNode = (NumericNode)typeFieldNode.get("minimum");
        Assertions.assertEquals((double)interval.getLeftMargin().doubleValue(), (double)numericNode.asDouble());
        Assertions.assertNull((Object)typeFieldNode.get("maximum"));
        Assertions.assertNull((Object)typeFieldNode.get("intervals"));
        typeFieldNode = JsonUtil.objectNode();
        interval = new Interval(null, (Number)35.0);
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.singletonList(interval));
        Assertions.assertNull((Object)typeFieldNode.get("minimum"));
        Assertions.assertNotNull((Object)typeFieldNode.get("maximum"));
        numericNode = (NumericNode)typeFieldNode.get("maximum");
        Assertions.assertEquals((double)interval.getRightMargin().doubleValue(), (double)numericNode.asDouble());
        Assertions.assertNull((Object)typeFieldNode.get("intervals"));
        typeFieldNode = JsonUtil.objectNode();
        interval = new Interval((Number)-34.23, (Number)35.0);
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.singletonList(interval));
        Assertions.assertNotNull((Object)typeFieldNode.get("minimum"));
        numericNode = (NumericNode)typeFieldNode.get("minimum");
        Assertions.assertEquals((double)interval.getLeftMargin().doubleValue(), (double)numericNode.asDouble());
        Assertions.assertNotNull((Object)typeFieldNode.get("maximum"));
        numericNode = (NumericNode)typeFieldNode.get("maximum");
        Assertions.assertEquals((double)interval.getRightMargin().doubleValue(), (double)numericNode.asDouble());
        Assertions.assertNull((Object)typeFieldNode.get("intervals"));
        typeFieldNode = JsonUtil.objectNode();
        List<Interval> intervals = IntStream.range(0, 3).mapToObj(i -> new Interval((Number)(i * 2 + 3), (Number)(i * 3 + 4))).collect(Collectors.toList());
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, intervals);
        Assertions.assertNull((Object)typeFieldNode.get("minimum"));
        Assertions.assertNull((Object)typeFieldNode.get("maximum"));
        Assertions.assertNotNull((Object)typeFieldNode.get("intervals"));
        ArrayNode intervalsNode = (ArrayNode)typeFieldNode.get("intervals");
        List<JsonNode> nodeList = StreamSupport.stream(intervalsNode.spliterator(), false).collect(Collectors.toList());
        nodeList.forEach(intervalNode -> Assertions.assertTrue((boolean)(intervalNode instanceof TextNode)));
        intervals.forEach(intervalValue -> {
            String leftMargin = intervalValue.getLeftMargin() != null ? intervalValue.getLeftMargin().toString() : "-" + PMMLOASUtils.INFINITY_SYMBOL;
            String rightMargin = intervalValue.getRightMargin() != null ? intervalValue.getRightMargin().toString() : PMMLOASUtils.INFINITY_SYMBOL;
            String expected = String.format("%s %s", leftMargin, rightMargin);
            Assertions.assertTrue((boolean)nodeList.stream().anyMatch(node -> expected.equals(node.asText())));
        });
    }

    @Test
    void addToSetNode() {
        String fieldName = "fieldName";
        DATA_TYPE dataType = DATA_TYPE.DOUBLE;
        ObjectNode setNode = PMMLOASUtils.createSetNode();
        ObjectNode propertiesNode = (ObjectNode)setNode.get("properties");
        Assertions.assertTrue((boolean)propertiesNode.isEmpty());
        PMMLOASUtils.addToSetNode((String)fieldName, (DATA_TYPE)dataType, Collections.emptyList(), (ObjectNode)setNode);
        Assertions.assertNotNull((Object)propertiesNode.get(fieldName));
        ObjectNode fieldNameNode = (ObjectNode)propertiesNode.get(fieldName);
        Assertions.assertNotNull((Object)fieldNameNode.get("type"));
        Assertions.assertEquals((Object)"number", (Object)fieldNameNode.get("type").asText());
        Assertions.assertNotNull((Object)fieldNameNode.get("format"));
        Assertions.assertEquals((Object)"double", (Object)fieldNameNode.get("format").asText());
        Assertions.assertNull((Object)fieldNameNode.get("enum"));
        List<String> allowedValues = IntStream.range(0, 3).mapToObj(it -> "VALUE" + it).collect(Collectors.toList());
        setNode = PMMLOASUtils.createSetNode();
        propertiesNode = (ObjectNode)setNode.get("properties");
        Assertions.assertTrue((boolean)propertiesNode.isEmpty());
        PMMLOASUtils.addToSetNode((String)fieldName, (DATA_TYPE)dataType, allowedValues, (ObjectNode)setNode);
        Assertions.assertNotNull((Object)propertiesNode.get(fieldName));
        fieldNameNode = (ObjectNode)propertiesNode.get(fieldName);
        Assertions.assertNotNull((Object)fieldNameNode.get("type"));
        Assertions.assertEquals((Object)"number", (Object)fieldNameNode.get("type").asText());
        Assertions.assertNotNull((Object)fieldNameNode.get("format"));
        Assertions.assertEquals((Object)"double", (Object)fieldNameNode.get("format").asText());
        ArrayNode availableValuesNode = (ArrayNode)fieldNameNode.get("enum");
        Assertions.assertEquals((int)allowedValues.size(), (int)availableValuesNode.size());
        List<JsonNode> nodeList = StreamSupport.stream(availableValuesNode.spliterator(), false).collect(Collectors.toList());
        nodeList.forEach(availableValueNode -> Assertions.assertTrue((boolean)(availableValueNode instanceof TextNode)));
        allowedValues.forEach(allowedValue -> Assertions.assertTrue((boolean)nodeList.stream().anyMatch(availableValueNode -> availableValueNode.asText().equals(allowedValue))));
    }

    @Test
    void conditionallyCreateEnumNode() {
        ObjectNode parentNode = JsonUtil.objectNode();
        ArrayNode created = PMMLOASUtils.conditionallyCreateEnumNode((ObjectNode)parentNode);
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((int)0, (int)created.size());
        JsonNode jsonNode = parentNode.get("enum");
        Assertions.assertNotNull((Object)jsonNode);
        Assertions.assertEquals((Object)created, (Object)jsonNode);
        ArrayNode notCreated = PMMLOASUtils.conditionallyCreateEnumNode((ObjectNode)parentNode);
        Assertions.assertNotNull((Object)notCreated);
        Assertions.assertEquals((Object)created, (Object)notCreated);
    }

    @Test
    void createSetNodeInParent() {
        ObjectNode parentNode = JsonUtil.objectNode();
        String nodeToCreate = "nodeToCreate";
        ObjectNode retrieved = PMMLOASUtils.createSetNodeInParent((ObjectNode)parentNode, (String)nodeToCreate);
        this.commonValidateSetNode(retrieved);
        Assertions.assertEquals((Object)retrieved, (Object)parentNode.get(nodeToCreate));
    }

    @Test
    void createSetNode() {
        ObjectNode retrieved = PMMLOASUtils.createSetNode();
        this.commonValidateSetNode(retrieved);
    }

    @Test
    void getNumericNode() {
        Number number = 1;
        NumericNode retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = Float.valueOf(1.0f);
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = 0.34;
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = new BigInteger("34343734734834872362532352352");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = Short.parseShort("1");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = Long.parseLong("343437347348348");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = new BigDecimal("343437347348348.2345345634634");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
    }

    private void commonValidateSetNode(ObjectNode toValidate) {
        Assertions.assertNotNull((Object)toValidate);
        JsonNode typeNode = toValidate.get("type");
        Assertions.assertNotNull((Object)typeNode);
        Assertions.assertTrue((boolean)(typeNode instanceof TextNode));
        Assertions.assertEquals((Object)"object", (Object)((TextNode)typeNode).asText());
        JsonNode propertiesNode = toValidate.get("properties");
        Assertions.assertNotNull((Object)propertiesNode);
        Assertions.assertTrue((boolean)(propertiesNode instanceof ObjectNode));
        Assertions.assertEquals((int)0, (int)propertiesNode.size());
    }

    private void commonValidateNumericNode(NumericNode toValidate, Number number) {
        String className;
        switch (className = number.getClass().getSimpleName()) {
            case "Integer": {
                Assertions.assertTrue((boolean)(toValidate instanceof IntNode));
                Assertions.assertEquals((Object)number, (Object)((IntNode)toValidate).intValue());
                break;
            }
            case "Float": {
                Assertions.assertTrue((boolean)(toValidate instanceof FloatNode));
                Assertions.assertEquals((Object)number, (Object)Float.valueOf(((FloatNode)toValidate).floatValue()));
                break;
            }
            case "Double": {
                Assertions.assertTrue((boolean)(toValidate instanceof DoubleNode));
                Assertions.assertEquals((Object)number, (Object)((DoubleNode)toValidate).doubleValue());
                break;
            }
            case "BigInteger": {
                Assertions.assertTrue((boolean)(toValidate instanceof BigIntegerNode));
                Assertions.assertEquals((Object)number, (Object)((BigIntegerNode)toValidate).bigIntegerValue());
                break;
            }
            case "Short": {
                Assertions.assertTrue((boolean)(toValidate instanceof ShortNode));
                Assertions.assertEquals((Object)number, (Object)((ShortNode)toValidate).shortValue());
                break;
            }
            case "Long": {
                Assertions.assertTrue((boolean)(toValidate instanceof LongNode));
                Assertions.assertEquals((Object)number, (Object)((LongNode)toValidate).longValue());
                break;
            }
            case "BigDecimal": {
                Assertions.assertTrue((boolean)(toValidate instanceof DecimalNode));
                Assertions.assertEquals((Object)number, (Object)((DecimalNode)toValidate).decimalValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Failed to find a NumericNode for " + number.getClass());
            }
        }
    }
}

