/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.kogito.pmml.PMMLKogito;
import org.kie.kogito.pmml.PmmlPredictionModel;
import org.kie.kogito.prediction.PredictionModel;
import org.kie.kogito.prediction.PredictionModelNotFoundException;
import org.kie.kogito.prediction.PredictionModels;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.core.utils.KnowledgeBaseUtils;

public abstract class AbstractPredictionModels
implements PredictionModels {
    private static final AtomicReference<Function<String, KieRuntimeFactory>> functionReference = new AtomicReference();
    public static final Function<String, KieRuntimeFactory> kieRuntimeFactoryFunction = s -> functionReference.get().apply((String)s);

    protected static void init(String ... pmmlFiles) {
        Map<KieBase, KieRuntimeFactory> kieRuntimeFactories = PMMLKogito.createKieRuntimeFactories(pmmlFiles);
        Function<String, KieRuntimeFactory> function = s -> kieRuntimeFactories.keySet().stream().filter(kieBase -> KnowledgeBaseUtils.getModel((KieBase)kieBase, (String)s).isPresent()).map(kieRuntimeFactories::get).findFirst().orElseThrow(() -> new PredictionModelNotFoundException("Failed to find KieRuntimeFactory for model " + s));
        functionReference.set(function);
    }

    public PredictionModel getPredictionModel(String modelName) {
        return new PmmlPredictionModel(this.getPMMLRuntime(modelName), modelName);
    }

    private PMMLRuntime getPMMLRuntime(String modelName) {
        return (PMMLRuntime)kieRuntimeFactoryFunction.apply(modelName).get(PMMLRuntime.class);
    }
}

