/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.util.io.FileSystemResource;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.kogito.pmml.KieRuntimeFactoryBuilder;
import org.kie.kogito.pmml.utils.PMMLUtils;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.core.PMMLContextImpl;

public class PMMLKogito {
    private PMMLKogito() {
    }

    public static Map<KieBase, KieRuntimeFactory> createKieRuntimeFactories(String ... pmmlPaths) {
        return PMMLKogito.commonCreateKieRuntimeFactory(KieRuntimeFactoryBuilder::fromResources, pmmlPaths);
    }

    public static Map<KieBase, KieRuntimeFactory> createKieRuntimeFactoriesWithInMemoryCompilation(String ... pmmlPaths) {
        return PMMLKogito.commonCreateKieRuntimeFactory(KieRuntimeFactoryBuilder::fromResourcesWithInMemoryCompilation, pmmlPaths);
    }

    public static PMMLModel modelByName(PMMLRuntime pmmlRuntime, String modelName) {
        List modelsWithName = pmmlRuntime.getPMMLModels().stream().filter(m -> modelName.equals(m.getName())).collect(Collectors.toList());
        if (modelsWithName.size() == 1) {
            return (PMMLModel)modelsWithName.get(0);
        }
        String errorMessage = String.format("Wrong number of model(s) with name '%s': %s", modelName, modelsWithName.size());
        throw new KiePMMLException(errorMessage);
    }

    public static PMML4Result evaluate(PMMLRuntime pmmlRuntime, String modelName, Map<String, Object> pmmlContext) {
        PMMLRequestData pmmlRequestData = PMMLUtils.getPMMLRequestData(modelName, pmmlContext);
        return pmmlRuntime.evaluate(modelName, (PMMLContext)new PMMLContextImpl(pmmlRequestData));
    }

    private static Map<KieBase, KieRuntimeFactory> commonCreateKieRuntimeFactory(Function<Stream<Resource>, Map<KieBase, KieRuntimeFactory>> factory, String ... pmmlPaths) {
        Stream<Resource> resources = Stream.of(pmmlPaths).map(FileSystemResource::new);
        return factory.apply(resources);
    }
}

