/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.JavaCompilationProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.quarkus.deployment.KogitoCompilationProvider;
import org.kie.kogito.quarkus.deployment.KogitoCompilerException;

public class DMNCompilationProvider
extends JavaCompilationProvider {
    public Set<String> handledExtensions() {
        return Collections.singleton(".dmn");
    }

    public final void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        File outputDirectory = context.getOutputDirectory();
        try {
            DecisionCodegen generator = DecisionCodegen.ofPath((Path[])new Path[]{context.getProjectDirectory().toPath().resolve("src/main/resources")});
            Collection generatedFiles = generator.generate();
            HashSet<File> generatedSourceFiles = new HashSet<File>();
            for (GeneratedFile file : generatedFiles) {
                Path path = KogitoCompilationProvider.pathOf(outputDirectory.getPath(), file.relativePath());
                Files.write(path, file.contents(), new OpenOption[0]);
                generatedSourceFiles.add(path.toFile());
            }
            super.compile(generatedSourceFiles, context);
        }
        catch (IOException e) {
            throw new KogitoCompilerException(e);
        }
    }
}

