/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoMessage;

public class JandexProtoGenerator
implements ProtoGenerator<ClassInfo> {
    private final IndexView index;
    private final DotName generatedAnnotation;
    private final DotName variableInfoAnnotation;

    public JandexProtoGenerator(IndexView index, DotName generatedAnnotation, DotName variableInfoAnnotation) {
        this.index = index;
        this.generatedAnnotation = generatedAnnotation;
        this.variableInfoAnnotation = variableInfoAnnotation;
    }

    public Proto generate(String packageName, Collection<ClassInfo> dataModel, String ... headers) {
        try {
            Proto proto = new Proto(packageName, headers);
            for (ClassInfo clazz : dataModel) {
                this.messageFromClass(proto, clazz, this.index, null, null, null);
            }
            return proto;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while generating proto for data model", e);
        }
    }

    public Proto generate(String messageComment, String fieldComment, String packageName, ClassInfo dataModel, String ... headers) {
        try {
            Proto proto = new Proto(packageName, headers);
            this.messageFromClass(proto, dataModel, this.index, packageName, messageComment, fieldComment);
            return proto;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while generating proto for data model", e);
        }
    }

    protected ProtoMessage messageFromClass(Proto proto, ClassInfo clazz, IndexView index, String packageName, String messageComment, String fieldComment) throws Exception {
        if (this.isHidden(clazz)) {
            return null;
        }
        String name = clazz.simpleName();
        String altName = this.getReferenceOfModel(clazz, "name");
        if (altName != null) {
            name = altName;
        }
        ProtoMessage message = new ProtoMessage(name, packageName == null ? clazz.name().prefix().toString() : packageName);
        for (FieldInfo pd : clazz.fields()) {
            String protoType;
            String completeFieldComment = fieldComment;
            if (Modifier.isStatic(pd.flags()) || Modifier.isTransient(pd.flags())) continue;
            AnnotationInstance variableInfo = pd.annotation(this.variableInfoAnnotation);
            if (variableInfo != null) {
                completeFieldComment = fieldComment + "\n @VariableInfo(tags=\"" + variableInfo.value("tags").asString() + "\")";
            }
            String fieldTypeString = pd.type().name().toString();
            DotName fieldType = pd.type().name();
            if (pd.type().kind() == Type.Kind.PARAMETERIZED_TYPE) {
                fieldTypeString = "Collection";
                List typeParameters = pd.type().asParameterizedType().arguments();
                if (typeParameters.isEmpty()) {
                    throw new IllegalArgumentException("Field " + pd.name() + " of class " + clazz.name().toString() + " uses collection without type information");
                }
                fieldType = ((Type)typeParameters.get(0)).name();
                protoType = this.protoType(fieldType.toString());
            } else {
                protoType = this.protoType(fieldTypeString);
            }
            if (protoType == null) {
                ClassInfo classInfo = index.getClassByName(fieldType);
                if (classInfo == null) {
                    throw new IllegalStateException("Cannot find class info in jandex index for " + fieldType);
                }
                ProtoMessage another = this.messageFromClass(proto, classInfo, index, packageName, messageComment, fieldComment);
                protoType = another.getName();
            }
            message.addField(this.applicabilityByType(fieldTypeString), protoType, pd.name()).setComment(completeFieldComment);
        }
        message.setComment(messageComment);
        proto.addMessage(message);
        return message;
    }

    public Collection<ClassInfo> extractDataClasses(Collection<ClassInfo> input, String targetDirectory) {
        HashSet<ClassInfo> dataModelClasses = new HashSet<ClassInfo>();
        for (ClassInfo modelClazz : input) {
            try {
                for (FieldInfo pd : modelClazz.fields()) {
                    if (pd.type().name().toString().startsWith("java.lang") || pd.type().name().toString().equals(Date.class.getCanonicalName())) continue;
                    dataModelClasses.add(this.index.getClassByName(pd.type().name()));
                }
                this.generateModelClassProto(modelClazz, targetDirectory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dataModelClasses;
    }

    protected void generateModelClassProto(ClassInfo modelClazz, String targetDirectory) throws Exception {
        String processId = this.getReferenceOfModel(modelClazz, "reference");
        String name = this.getReferenceOfModel(modelClazz, "name");
        if (processId != null) {
            Proto modelProto = this.generate("@Indexed", "@Field(store = Store.YES)", modelClazz.name().prefix().toString() + "." + processId, modelClazz, "import \"kogito-index.proto\";", "import \"kogito-types.proto\";", "option kogito_model = \"" + name + "\";", "option kogito_id = \"" + processId + "\";");
            if (modelProto.getMessages().isEmpty()) {
                return;
            }
            ProtoMessage modelMessage = modelProto.getMessages().stream().filter(msg -> msg.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find model message"));
            modelMessage.addField("optional", "org.kie.kogito.index.model.KogitoMetadata", "metadata").setComment("@Field(store = Store.YES)");
            Path protoFilePath = Paths.get(targetDirectory, "classes", "/persistence/" + processId + ".proto");
            Files.createDirectories(protoFilePath.getParent(), new FileAttribute[0]);
            Files.write(protoFilePath, modelProto.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    protected String getReferenceOfModel(ClassInfo modelClazz, String name) {
        AnnotationInstance generatedData = modelClazz.classAnnotation(this.generatedAnnotation);
        if (generatedData != null) {
            return generatedData.value(name).asString();
        }
        return null;
    }

    protected boolean isHidden(ClassInfo modelClazz) {
        AnnotationInstance generatedData = modelClazz.classAnnotation(this.generatedAnnotation);
        if (generatedData != null) {
            return generatedData.value("hidden").asBoolean();
        }
        return false;
    }
}

