/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.bootstrap.model.PathsCollection;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppPaths {
    private static final Logger logger = LoggerFactory.getLogger(AppPaths.class);
    final Set<Path> projectPaths = new LinkedHashSet<Path>();
    final List<Path> classesPaths = new ArrayList<Path>();
    boolean isJar = false;

    AppPaths(PathsCollection paths) {
        for (Path path : paths) {
            PathType pathType = this.getPathType(path);
            switch (pathType) {
                case CLASSES: {
                    this.classesPaths.add(path);
                    this.projectPaths.add(path.getParent().getParent());
                    break;
                }
                case TEST_CLASSES: {
                    this.projectPaths.add(path.getParent().getParent());
                    break;
                }
                case JAR: {
                    this.isJar = true;
                    this.classesPaths.add(path);
                    this.projectPaths.add(path.getParent().getParent());
                    break;
                }
                case UNKNOWN: {
                    this.classesPaths.add(path);
                    this.projectPaths.add(path);
                }
            }
        }
    }

    public Path[] getPath() {
        if (this.isJar) {
            return this.getJarPath();
        }
        return this.getResourcePaths();
    }

    public Path getFirstProjectPath() {
        return this.projectPaths.iterator().next();
    }

    public Path getFirstClassesPath() {
        return this.classesPaths.get(0);
    }

    public Path[] getJarPath() {
        if (!this.isJar) {
            throw new IllegalStateException("Not a jar");
        }
        return this.classesPaths.toArray(new Path[this.classesPaths.size()]);
    }

    public File[] getResourceFiles() {
        return (File[])this.projectPaths.stream().map(p -> p.resolve("src/main/resources").toFile()).toArray(File[]::new);
    }

    public Path[] getResourcePaths() {
        return this.transformPaths(this.projectPaths, p -> p.resolve("src/main/resources"));
    }

    public Path[] getSourcePaths() {
        return this.transformPaths(this.projectPaths, p -> p.resolve("src"));
    }

    public Path[] getProjectPaths() {
        return this.transformPaths(this.projectPaths, Function.identity());
    }

    private Path[] transformPaths(Collection<Path> paths, Function<Path, Path> f) {
        return (Path[])paths.stream().map(f).toArray(Path[]::new);
    }

    private PathType getPathType(Path archiveLocation) {
        String path = archiveLocation.toString();
        if (path.endsWith("target" + File.separator + "classes")) {
            return PathType.CLASSES;
        }
        if (path.endsWith("target" + File.separator + "test-classes")) {
            return PathType.TEST_CLASSES;
        }
        if (path.endsWith(".jar") || path.endsWith(".jar.original")) {
            return PathType.JAR;
        }
        return PathType.UNKNOWN;
    }

    private static enum PathType {
        CLASSES,
        TEST_CLASSES,
        JAR,
        UNKNOWN;

    }
}

