/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.kie.kogito.Model;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.Generated;
import org.kie.kogito.codegen.VariableInfo;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.quarkus.common.deployment.InMemoryClassLoader;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.kie.kogito.quarkus.deployment.JandexProtoGenerator;

public class ProcessesAssetsProcessor {
    private static final DotName persistenceFactoryClass = DotName.createSimple((String)"org.kie.kogito.persistence.KogitoProcessInstancesFactory");
    private static final String PROCESS_SVG_SERVICE = "org.kie.kogito.svg.service.QuarkusProcessSvgService";
    private static final PathMatcher svgFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.svg");
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("kogito-processes");
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito-processes");
    }

    @BuildStep
    public void postGenerationProcessing(List<KogitoGeneratedClassesBuildItem> generatedKogitoClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedResourceBuildItem> genResBI, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration) throws IOException {
        IndexView aggregatedIndex = KogitoQuarkusResourceUtils.generateAggregatedIndex((IndexView)this.combinedIndexBuildItem.getIndex(), generatedKogitoClasses);
        KogitoBuildContext context = KogitoQuarkusResourceUtils.kogitoBuildContext((Iterable)this.root.getPaths(), (IndexView)aggregatedIndex, (AppArtifact)this.curateOutcomeBuildItem.getEffectiveModel().getAppArtifact());
        Collection<GeneratedFile> generatedFiles = this.generatePersistenceInfo(context, aggregatedIndex, generatedBeans, resource, reflectiveClass, runTimeConfiguration, this.liveReload.isLiveReload());
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (KogitoGeneratedClassesBuildItem generatedKogitoClass : generatedKogitoClasses) {
            classes.putAll(generatedKogitoClass.getGeneratedClasses());
        }
        generatedFiles.addAll(this.generateJsonSchema(context, aggregatedIndex, classes));
        KogitoQuarkusResourceUtils.dumpFilesToDisk((AppPaths)context.getAppPaths(), generatedFiles);
        KogitoQuarkusResourceUtils.registerResources(generatedFiles, resource, genResBI);
        this.registerProcessSVG(context, resource);
    }

    private Collection<GeneratedFile> generatePersistenceInfo(KogitoBuildContext context, IndexView index, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, boolean useDebugSymbols) throws IOException {
        if (context.getAddonsConfig().usePersistence()) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
        }
        Collection<GeneratedFile> persistenceGeneratedFiles = this.getGeneratedPersistenceFiles(index, context, reflectiveClass, runTimeConfiguration);
        GeneratedFileValidation.validateGeneratedFileTypes(persistenceGeneratedFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.RESOURCE));
        List dependencies = this.curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        KogitoQuarkusResourceUtils.compileGeneratedSources((KogitoBuildContext)context, (List)dependencies, persistenceGeneratedFiles, (boolean)useDebugSymbols).forEach(arg_0 -> generatedBeans.produce(arg_0));
        return persistenceGeneratedFiles.stream().filter(x -> x.category().equals((Object)GeneratedFileType.Category.RESOURCE)).collect(Collectors.toList());
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(IndexView index, KogitoBuildContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration) {
        ClassInfo persistenceClass = index.getClassByName(persistenceFactoryClass);
        Collection modelClasses = index.getAllKnownImplementors(DotName.createSimple((String)Model.class.getCanonicalName()));
        JandexProtoGenerator protoGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(index, DotName.createSimple((String)Generated.class.getCanonicalName()), DotName.createSimple((String)VariableInfo.class.getCanonicalName())).withPersistenceClass((Object)persistenceClass).build(modelClasses);
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator);
        if (persistenceGenerator.persistenceType().equals("mongodb")) {
            this.addInnerClasses(JBPMMessages.class, reflectiveClass);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"java.lang.String"}));
        } else if (persistenceGenerator.persistenceType().equals("kafka")) {
            String processIds = protoGenerator.getProcessIds().stream().map(s -> "kogito.process." + s).collect(Collectors.joining(","));
            runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.kafka-streams.topics", processIds));
        }
        return persistenceGenerator.generate();
    }

    private void addInnerClasses(Class<?> superClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Arrays.asList(superClass.getDeclaredClasses()).forEach(c -> {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.getName()}));
            this.addInnerClasses((Class<?>)c, reflectiveClass);
        });
    }

    private void registerProcessSVG(KogitoBuildContext context, BuildProducer<NativeImageResourceBuildItem> resource) throws IOException {
        if (!context.hasClassAvailable(PROCESS_SVG_SERVICE)) {
            return;
        }
        Path relativePath = Paths.get("META-INF", "processSVG");
        Path targetClasses = KogitoQuarkusResourceUtils.getTargetClassesPath((AppPaths)context.getAppPaths());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"org/apache/batik/util/resources/XMLResourceDescriptor.properties"}));
        Path resolvedPath = targetClasses.resolve(relativePath);
        try (Stream<Path> filePathFound = Files.find(resolvedPath, Integer.MAX_VALUE, (filePath, attrs) -> svgFileMatcher.matches((Path)filePath), new FileVisitOption[0]);){
            List svgs = filePathFound.map(svgPath -> targetClasses.relativize((Path)svgPath).toString()).collect(Collectors.toList());
            resource.produce((BuildItem)new NativeImageResourceBuildItem(svgs));
        }
    }

    private Collection<GeneratedFile> generateJsonSchema(KogitoBuildContext context, IndexView index, Map<String, byte[]> generatedClasses) throws IOException {
        InMemoryClassLoader cl = new InMemoryClassLoader(context.getClassLoader(), generatedClasses);
        Collection annotations = index.getAnnotations(DotName.createSimple((String)UserTask.class.getCanonicalName()));
        Stream<Class> stream = annotations.stream().map(arg_0 -> this.lambda$generateJsonSchema$5((ClassLoader)cl, arg_0)).filter(Optional::isPresent).map(Optional::get);
        JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator.ClassBuilder(stream).withGenSchemaPredicate(x -> true).withSchemaVersion(System.getProperty("kogito.jsonSchema.version")).build();
        return jsonSchemaGenerator.generate();
    }

    private Optional<Class<?>> loadClassFromAnnotation(AnnotationInstance annotationInstance, ClassLoader classLoader) {
        try {
            return Optional.of(classLoader.loadClass(annotationInstance.target().asClass().name().toString()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private /* synthetic */ Optional lambda$generateJsonSchema$5(ClassLoader cl, AnnotationInstance ann) {
        return this.loadClassFromAnnotation(ann, cl);
    }
}

