/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.kogito.jbpm;

import io.quarkus.it.kogito.jbpm.Order;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;

@Path(value="/runProcess")
public class OrdersProcessService {
    @Inject
    @Named(value="demo.orders")
    Process<? extends Model> orderProcess;
    @Inject
    @Named(value="demo.orderItems")
    Process<? extends Model> orderItemsProcess;

    @GET
    @Produces(value={"text/plain"})
    public String testOrderProcess() {
        Model m = (Model)this.orderProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("approver", "john");
        parameters.put("order", new Order("12345", false, 0.0));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.orderProcess.createInstance(m);
        processInstance.start();
        assert (1 == processInstance.status());
        Model result = (Model)processInstance.variables();
        assert (result.toMap().size() == 2);
        assert (((Order)result.toMap().get("order")).getTotal() > 0.0);
        ProcessInstances orderItemProcesses = this.orderItemsProcess.instances();
        assert (orderItemProcesses.values().size() == 1);
        ProcessInstance childProcessInstance = (ProcessInstance)orderItemProcesses.values().iterator().next();
        List workItems = childProcessInstance.workItems(new Policy[0]);
        assert (workItems.size() == 1);
        childProcessInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        assert (2 == childProcessInstance.status());
        assert (2 == processInstance.status());
        assert (this.orderProcess.instances().values().size() == 0);
        assert (this.orderItemsProcess.instances().values().size() == 0);
        return "OK";
    }
}

