/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.resources;

import com.google.common.base.Strings;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.kie.kogito.test.quarkus.QuarkusTestProperty;
import org.kie.kogito.test.resources.ConditionHolder;
import org.kie.kogito.test.resources.TestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConditionalQuarkusTestResource<T extends TestResource>
implements QuarkusTestResourceLifecycleManager {
    private static Logger LOGGER = LoggerFactory.getLogger(ConditionalQuarkusTestResource.class);
    private final T testResource;
    private final ConditionHolder condition;
    private boolean conditionalEnabled = false;

    public ConditionalQuarkusTestResource(T testResource) {
        this(testResource, new ConditionHolder(testResource.getResourceName()));
    }

    public ConditionalQuarkusTestResource(T testResource, ConditionHolder condition) {
        this.testResource = testResource;
        this.condition = condition;
    }

    public T getTestResource() {
        return this.testResource;
    }

    public boolean isConditionalEnabled() {
        return this.conditionalEnabled;
    }

    public Map<String, String> start() {
        if (this.condition.isEnabled()) {
            this.testResource.start();
            return this.getProperties();
        }
        return Collections.emptyMap();
    }

    public void stop() {
        if (this.condition.isEnabled()) {
            this.testResource.stop();
        }
    }

    public void inject(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                QuarkusTestProperty quarkusTestProperty = f.getAnnotation(QuarkusTestProperty.class);
                if (quarkusTestProperty != null) {
                    String value = Optional.ofNullable(this.getProperties().get(quarkusTestProperty.name())).orElse(quarkusTestProperty.defaultValue());
                    if (Strings.isNullOrEmpty((String)value)) continue;
                    this.setFieldValue(f, testInstance, value);
                    continue;
                }
                if (!f.isAnnotationPresent(Resource.class) || !f.getType().isInstance(this)) continue;
                this.setFieldValue(f, testInstance, this);
            }
        }
    }

    protected abstract Map<String, String> getProperties();

    protected void enableConditional() {
        this.condition.enableConditional();
        this.conditionalEnabled = true;
    }

    private void setFieldValue(Field f, Object testInstance, Object value) {
        try {
            f.setAccessible(true);
            f.set(testInstance, value);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

