/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.quarkus.kafka;

import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.kie.kogito.test.quarkus.kafka.KafkaConsumerLoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaTestClient.class);
    private static final int TIMEOUT = 10;
    private ExecutorService executorService;
    private KafkaConsumerLoop consumer;
    private String hosts;

    public KafkaTestClient(String hosts) {
        this.hosts = hosts;
    }

    private KafkaConsumer<String, String> createDefaultConsumer(String hosts) {
        Properties consumerConfig = new Properties();
        consumerConfig.put("enable.auto.commit", "false");
        consumerConfig.put("auto.offset.reset", "earliest");
        consumerConfig.put("bootstrap.servers", hosts);
        consumerConfig.put("key.deserializer", StringDeserializer.class.getName());
        consumerConfig.put("value.deserializer", StringDeserializer.class.getName());
        consumerConfig.put("group.id", KafkaTestClient.class.getName() + "Consumer");
        return new KafkaConsumer(consumerConfig);
    }

    private KafkaProducer<String, String> createDefaultProducer(String hosts) {
        Properties producerConfig = new Properties();
        producerConfig.put("bootstrap.servers", hosts);
        producerConfig.put("acks", "all");
        producerConfig.put("client.id", KafkaTestClient.class.getName() + "Producer");
        producerConfig.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerConfig.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return new KafkaProducer(producerConfig);
    }

    public void consume(Set<String> topics, Consumer<String> callback) {
        if (this.consumer != null) {
            this.shutdown();
        }
        this.executorService = Executors.newSingleThreadExecutor();
        CountDownLatch awaitSubscribe = new CountDownLatch(1);
        this.consumer = new KafkaConsumerLoop(this.createDefaultConsumer(this.hosts), topics, callback, v -> {
            awaitSubscribe.countDown();
            return null;
        });
        this.executorService.execute(this.consumer);
        try {
            if (!awaitSubscribe.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException(String.format("Timeout while waiting for KafkaTestClient to subscribe to topics: %s", topics));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void consume(String topic, Consumer<String> callback) {
        this.consume(Collections.singleton(topic), callback);
    }

    public void produce(String data, String topic) {
        try (KafkaProducer<String, String> producer = this.createDefaultProducer(this.hosts);){
            LOGGER.info("Publishing event with data {} for topic {}", (Object)data, (Object)topic);
            ProducerRecord record = new ProducerRecord(topic, (Object)data);
            this.waitForCompletion(producer.send(record));
        }
    }

    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.shutdown();
            this.consumer = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.executorService.shutdownNow();
            }
            this.executorService = null;
        }
    }

    public void waitForCompletion(Future future) {
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new KafkaException(e.getCause());
        }
    }
}

