/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.resources;

import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.test.quarkus.QuarkusTestProperty;
import org.kie.kogito.test.resources.ConditionHolder;
import org.kie.kogito.test.resources.ConditionalQuarkusTestResource;
import org.kie.kogito.test.resources.TestResource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ConditionalQuarkusTestResourceTest {
    private static final int MAPPED_PORT = 8800;
    private static final String PROPERTY_KEY = "property-key";
    private static final String PROPERTY_VALUE = "localhost:8800";
    private static final String PROPERTY_DEFAULT_VALUE = "PROPERTY_DEFAULT_VALUE";
    @Mock
    private TestResource resource;
    @Mock
    private ConditionHolder conditional;
    private ConditionalQuarkusTestResource instance;
    private Map<String, String> actualOutput;
    private TestInstance testInstance;

    @BeforeEach
    public void setup() {
        this.instance = new ConditionalQuarkusTestResource(this.resource, this.conditional){

            protected Map<String, String> getProperties() {
                return Collections.singletonMap(ConditionalQuarkusTestResourceTest.PROPERTY_KEY, ConditionalQuarkusTestResourceTest.PROPERTY_VALUE);
            }
        };
        this.actualOutput = null;
        this.testInstance = new TestInstance();
        Mockito.lenient().when((Object)this.resource.getMappedPort()).thenReturn((Object)8800);
    }

    @Test
    public void shouldReturnResource() {
        Assertions.assertEquals((Object)this.resource, (Object)this.instance.getTestResource());
    }

    @Test
    public void shouldInvokeConditional() {
        this.instance.enableConditional();
        ((ConditionHolder)Mockito.verify((Object)this.conditional)).enableConditional();
    }

    @Test
    public void shouldStartIfConditionalIsEnabled() {
        this.givenConditionalEnabled();
        this.whenStartInstance();
        this.thenResourceIsStarted();
        this.thenConfigMapIsUpdated();
    }

    @Test
    public void shouldNotStartIfConditionalIsDisabled() {
        this.givenConditionalDisabled();
        this.whenStartInstance();
        this.thenResourceIsNotUsed();
    }

    @Test
    public void shouldStopIfConditionalIsEnabled() {
        this.givenConditionalEnabled();
        this.whenStopInstance();
        this.thenResourceIsStopped();
    }

    @Test
    public void shouldNotStopIfConditionalIsDisabled() {
        this.givenConditionalDisabled();
        this.whenStopInstance();
        this.thenResourceIsNotUsed();
    }

    @Test
    public void shouldInjectQuarkusIntegrationTestProperty() {
        this.whenInjectTestInstance();
        this.thenPropertyValueIsUpdated();
        this.thenPropertyValueWithDefaultValueIsUpdated();
        this.thenOtherPropertyValueIsNotUpdated();
        this.thenResourceIsUpdated();
    }

    private void givenConditionalEnabled() {
        Mockito.when((Object)this.conditional.isEnabled()).thenReturn((Object)true);
    }

    private void givenConditionalDisabled() {
        Mockito.when((Object)this.conditional.isEnabled()).thenReturn((Object)false);
    }

    private void whenStartInstance() {
        this.actualOutput = this.instance.start();
    }

    private void whenStopInstance() {
        this.instance.stop();
    }

    private void whenInjectTestInstance() {
        this.instance.inject((Object)this.testInstance);
    }

    private void thenResourceIsStarted() {
        ((TestResource)Mockito.verify((Object)this.resource)).start();
    }

    private void thenResourceIsStopped() {
        ((TestResource)Mockito.verify((Object)this.resource)).stop();
    }

    private void thenResourceIsNotUsed() {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.resource});
    }

    private void thenConfigMapIsUpdated() {
        String actual = this.actualOutput.get(PROPERTY_KEY);
        Assertions.assertEquals((Object)PROPERTY_VALUE, (Object)actual);
    }

    private void thenPropertyValueIsUpdated() {
        Assertions.assertEquals((Object)PROPERTY_VALUE, (Object)this.testInstance.propertyValue);
    }

    private void thenPropertyValueWithDefaultValueIsUpdated() {
        Assertions.assertEquals((Object)PROPERTY_DEFAULT_VALUE, (Object)this.testInstance.propertyWithDefaultValue);
    }

    private void thenOtherPropertyValueIsNotUpdated() {
        Assertions.assertNull((Object)this.testInstance.otherPropertyValue);
    }

    private void thenResourceIsUpdated() {
        Assertions.assertEquals((Object)this.instance, (Object)this.testInstance.resource);
    }

    private class TestInstance {
        @QuarkusTestProperty(name="property-key")
        private String propertyValue;
        @QuarkusTestProperty(name="property-key-with-default", defaultValue="PROPERTY_DEFAULT_VALUE")
        private String propertyWithDefaultValue;
        @QuarkusTestProperty(name="other-property-key")
        private String otherPropertyValue;
        @Resource
        private ConditionalQuarkusTestResource resource;

        private TestInstance() {
        }
    }
}

