/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.workflow;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.properties.IfBuildProperty;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import java.util.concurrent.ScheduledExecutorService;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.config.ConfigBean;
import org.kie.kogito.correlation.CorrelationService;
import org.kie.kogito.event.correlation.DefaultCorrelationService;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.ProcessVersionResolver;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.version.ProjectVersionProcessVersionResolver;
import org.kie.kogito.services.jobs.impl.InMemoryJobContext;
import org.kie.kogito.services.jobs.impl.InMemoryJobService;
import org.kie.kogito.services.jobs.impl.InMemoryProcessJobExecutorFactory;
import org.kie.kogito.services.jobs.impl.JobExecutorFactory;
import org.kie.kogito.services.uow.StaticUnitOfWorkManger;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.usertask.UserTasks;

@ApplicationScoped
public class KogitoBeanProducer {
    public static final String KOGITO_WORKFLOW_VERSION_STRATEGY = "kogito.workflow.version-strategy";

    @DefaultBean
    @Produces
    CorrelationService correlationService() {
        return new DefaultCorrelationService();
    }

    @DefaultBean
    @Produces
    UnitOfWorkManager unitOfWorkManager() {
        return StaticUnitOfWorkManger.staticUnitOfWorkManager();
    }

    @DefaultBean
    @Produces
    JobsService jobsService(Instance<Processes> processes, Instance<UserTasks> userTasks, UnitOfWorkManager uowm, ScheduledExecutorService executor) {
        InMemoryJobContext context = new InMemoryJobContext(null, uowm, processes.isResolvable() ? (Processes)processes.get() : null, userTasks.isResolvable() ? (UserTasks)userTasks.get() : null);
        InMemoryJobService inMemoryJobService = new InMemoryJobService(executor);
        inMemoryJobService.registerJobExecutorFactory((JobExecutorFactory)new InMemoryProcessJobExecutorFactory(context));
        return inMemoryJobService;
    }

    @Produces
    @IfBuildProperty(name="kogito.workflow.version-strategy", stringValue="project")
    ProcessVersionResolver projectVersionResolver(ConfigBean configBean) {
        return new ProjectVersionProcessVersionResolver((KogitoGAV)configBean.getGav().orElseThrow(() -> new RuntimeException("Unable to use kogito.workflow.version-strategy without a project GAV")));
    }
}

