/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.scenariosimulation.runner;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.DMNScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoDMNScenarioRunnerHelper
extends DMNScenarioRunnerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KogitoDMNScenarioRunnerHelper.class);
    private DMNRuntime dmnRuntime = null;

    public KogitoDMNScenarioRunnerHelper() {
        try (Stream<Path> fileStream = Files.walk(Paths.get(".", new String[0]), new FileVisitOption[0]);){
            List resources = fileStream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".dmn")).peek(x -> System.out.println(x)).map(Path::toFile).map(FileSystemResource::new).collect(Collectors.toList());
            this.dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().setRootClassLoader(null).buildConfiguration().fromResources(resources).getOrElseThrow(e -> new RuntimeException("Error initalizing DMNRuntime", (Throwable)e));
        }
        catch (IOException e2) {
            throw new RuntimeException("Error initalizing KogitoDMNScenarioRunnerHelper", e2);
        }
    }

    protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, ScesimModelDescriptor scesimModelDescriptor, Settings settings) {
        if (!ScenarioSimulationModel.Type.DMN.equals((Object)settings.getType())) {
            throw new ScenarioException("Impossible to run a not-DMN simulation with DMN runner");
        }
        DMNModel dmnModel = this.getDMNModel(this.dmnRuntime, settings);
        DMNContext dmnContext = this.dmnRuntime.newContext();
        this.loadInputData(scenarioRunnerData.getBackgrounds(), dmnContext);
        this.loadInputData(scenarioRunnerData.getGivens(), dmnContext);
        DMNResult dmnResult = this.dmnRuntime.evaluateAll(dmnModel, dmnContext);
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put(DMNScenarioExecutableBuilder.DMN_MODEL, dmnModel);
        toReturn.put(DMNScenarioExecutableBuilder.DMN_RESULT, dmnResult);
        return toReturn;
    }

    private DMNModel getDMNModel(DMNRuntime dmnRuntime, Settings settings) {
        try {
            return DMNSimulationUtils.extractDMNModel((DMNRuntime)dmnRuntime, (String)settings.getDmnFilePath());
        }
        catch (Exception e) {
            return dmnRuntime.getModel(settings.getDmnNamespace(), settings.getDmnName());
        }
    }

    protected void loadInputData(List<InstanceGiven> dataToLoad, DMNContext dmnContext) {
        for (InstanceGiven input : dataToLoad) {
            dmnContext.set(input.getFactIdentifier().getName(), input.getValue());
        }
    }
}

