/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.scenariosimulation.runner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.codegen.common.AppPaths;
import org.drools.io.FileSystemResource;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;

public class KogitoDMNScenarioRunnerHelper
extends DMNScenarioRunnerHelper {
    private DMNRuntime dmnRuntime = this.initDmnRuntime();
    private static final String targetFolder = File.separator + AppPaths.TARGET_DIR + File.separator;
    private static final String generatedResourcesFolder = targetFolder + "generated-resources" + File.separator;

    protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, ScesimModelDescriptor scesimModelDescriptor, Settings settings) {
        if (!ScenarioSimulationModel.Type.DMN.equals((Object)settings.getType())) {
            throw new ScenarioException("Impossible to run a not-DMN simulation with DMN runner");
        }
        DMNModel dmnModel = this.getDMNModel(this.dmnRuntime, settings);
        DMNContext dmnContext = this.dmnRuntime.newContext();
        this.defineInputValues(scenarioRunnerData.getBackgrounds(), scenarioRunnerData.getGivens()).forEach((arg_0, arg_1) -> ((DMNContext)dmnContext).set(arg_0, arg_1));
        DMNResult dmnResult = this.dmnRuntime.evaluateAll(dmnModel, dmnContext);
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("dmnModel", dmnModel);
        toReturn.put("dmnResult", dmnResult);
        return toReturn;
    }

    private DMNModel getDMNModel(DMNRuntime dmnRuntime, Settings settings) {
        try {
            return DMNSimulationUtils.extractDMNModel((DMNRuntime)dmnRuntime, (String)settings.getDmnFilePath());
        }
        catch (Exception e) {
            return dmnRuntime.getModel(settings.getDmnNamespace(), settings.getDmnName());
        }
    }

    private DMNRuntime initDmnRuntime() {
        DMNRuntime dMNRuntime;
        block8: {
            Stream<Path> fileStream = Files.walk(Paths.get(".", new String[0]), new FileVisitOption[0]);
            try {
                List resources = fileStream.filter(path -> this.filterResource((Path)path, ".dmn")).map(Path::toFile).map(FileSystemResource::new).collect(Collectors.toList());
                dMNRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(resources).getOrElseThrow(e -> new RuntimeException("Error initializing DMNRuntime", (Throwable)e));
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new IllegalStateException("Error initializing KogitoDMNScenarioRunnerHelper", e2);
                }
            }
            fileStream.close();
        }
        return dMNRuntime;
    }

    private boolean filterResource(Path path, String extension) {
        return path.toString().endsWith(extension) && (path.toString().contains(generatedResourcesFolder) || !path.toString().contains(targetFolder)) && Files.isRegularFile(path, new LinkOption[0]);
    }
}

